/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.core.teleport;

import com.tcn.cosmoslibrary.common.lib.MathHelper;
import com.tcn.cosmoslibrary.core.teleport.EnumSafeTeleport;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class CosmosTeleporter
implements ITeleporter {
    private ResourceKey<Level> dimension_key;
    private BlockPos target_pos;
    private float target_yaw;
    private float target_pitch;
    private boolean playVanillaSound;
    private boolean sendMessage;
    private boolean safeSpawn;

    public CosmosTeleporter(ResourceKey<Level> dimensionKeyIn, BlockPos targetPosIn, float targetYawIn, float targetPitchIn, boolean playVanillaSoundIn, boolean sendMessageIn, boolean safeSpawnIn) {
        this.dimension_key = dimensionKeyIn;
        this.target_pos = targetPosIn;
        this.target_yaw = targetYawIn;
        this.target_pitch = targetPitchIn;
        this.playVanillaSound = playVanillaSoundIn;
        this.sendMessage = sendMessageIn;
        this.safeSpawn = safeSpawnIn;
    }

    public BlockPos getTargetPos() {
        return this.target_pos;
    }

    public double[] getTargetPosA() {
        return new double[]{this.target_pos.m_123341_(), this.target_pos.m_123342_(), this.target_pos.m_123343_()};
    }

    public float getTargetYaw() {
        return this.target_yaw;
    }

    public float getTargetPitch() {
        return this.target_pitch;
    }

    public float[] getTargetRotation() {
        return new float[]{this.target_yaw, this.target_pitch};
    }

    public ResourceKey<Level> getDimensionKey() {
        return this.dimension_key;
    }

    public static CosmosTeleporter createTeleporter(ResourceKey<Level> dimensionKeyIn, BlockPos targetPosIn, float targetYawIn, float targetPitchIn, boolean playVanillaSoundIn, boolean sendMessageIn, boolean safeSpawnIn) {
        return new CosmosTeleporter(dimensionKeyIn, targetPosIn, targetYawIn, targetPitchIn, playVanillaSoundIn, sendMessageIn, safeSpawnIn);
    }

    public boolean playVanillaSound() {
        return this.playVanillaSound;
    }

    public boolean getSendMessage() {
        return this.sendMessage;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        return repositionEntity.apply(false);
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return this.playVanillaSound;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        EnumSafeTeleport spawnLocation;
        if (this.safeSpawn && (spawnLocation = EnumSafeTeleport.getValidTeleportLocation((Level)destWorld, this.target_pos)) != EnumSafeTeleport.UNKNOWN) {
            BlockPos resultPos = spawnLocation.toBlockPos();
            BlockPos combinedPos = MathHelper.addBlockPos(this.target_pos, resultPos);
            return new PortalInfo(new Vec3((double)((float)combinedPos.m_123341_() + 0.5f), (double)combinedPos.m_123342_(), (double)((float)combinedPos.m_123343_() + 0.5f)), Vec3.f_82478_, this.getTargetYaw(), this.getTargetPitch());
        }
        return new PortalInfo(new Vec3((double)((float)this.target_pos.m_123341_() + 0.5f), (double)this.target_pos.m_123342_(), (double)((float)this.target_pos.m_123343_() + 0.5f)), Vec3.f_82478_, this.getTargetYaw(), this.getTargetPitch());
    }
}

