/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.energy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.tcn.cosmoslibrary.common.item.CosmosArmourItemColourable;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.energy.interfaces.ICosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CosmosEnergyArmourItemColourable
extends CosmosArmourItemColourable
implements ICosmosEnergyItem {
    private int maxEnergyStored;
    private int maxExtract;
    private int maxReceive;
    private int maxUse;
    private boolean doesExtract;
    private boolean doesCharge;
    private boolean doesDisplayEnergyInTooltip;
    private ComponentColour barColour;
    private boolean isEnderMask;

    public CosmosEnergyArmourItemColourable(ArmorMaterial materialIn, ArmorItem.Type typeIn, boolean isEnderMaskIn, Item.Properties builderIn, CosmosEnergyItem.Properties energyProperties) {
        super(materialIn, typeIn, builderIn);
        this.maxEnergyStored = energyProperties.maxEnergyStored;
        this.maxExtract = energyProperties.maxExtract;
        this.maxReceive = energyProperties.maxReceive;
        this.maxUse = energyProperties.maxUse;
        this.doesExtract = energyProperties.doesExtract;
        this.doesCharge = energyProperties.doesCharge;
        this.doesDisplayEnergyInTooltip = energyProperties.doesDisplayEnergyInTooltip;
        this.barColour = energyProperties.barColour;
        this.isEnderMask = isEnderMaskIn;
        builderIn.setNoRepair();
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        return this.isEnderMask;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            CompoundTag stackTag = stack.m_41783_();
            tooltip.add((Component)ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.tooltip.energy_item.stored").m_7220_((Component)ComponentHelper.comp("\u00a77[ \u00a74" + CosmosUtil.formatIntegerMillion(stackTag.m_128451_("energy")) + "\u00a77 / \u00a74" + CosmosUtil.formatIntegerMillion(this.getMaxEnergyStored(stack)) + "\u00a77 ]")));
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)itemstack);
        ItemStack itemstack1 = playerIn.m_6844_(equipmentslottype);
        if (itemstack1.m_41619_()) {
            playerIn.m_8061_(equipmentslottype, itemstack.m_41777_());
            if (!levelIn.m_5776_()) {
                playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            itemstack.m_41764_(0);
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)levelIn.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stackIn, int amount, T entity, Consumer<T> onBroken) {
        if (this.getDamage(stackIn) < this.getMaxDamage(stackIn)) {
            this.setDamage(stackIn, 0);
        }
        if (entity instanceof Player && this.hasEnergy(stackIn)) {
            this.extractEnergy(stackIn, this.getMaxUse(stackIn), false);
        }
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotIn, ItemStack stackIn) {
        if (!this.hasEnergy(stackIn)) {
            return ImmutableMultimap.of();
        }
        return this.m_7167_(slotIn);
    }

    @Override
    public int getMaxEnergyStored(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? 0 : ((CosmosEnergyArmourItemColourable)item).maxEnergyStored;
    }

    @Override
    public int getMaxExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? 0 : ((CosmosEnergyArmourItemColourable)item).maxExtract;
    }

    @Override
    public int getMaxReceive(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? 0 : ((CosmosEnergyArmourItemColourable)item).maxReceive;
    }

    @Override
    public int getMaxUse(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? 0 : ((CosmosEnergyArmourItemColourable)item).maxUse;
    }

    @Override
    public boolean doesExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? false : ((CosmosEnergyArmourItemColourable)item).doesExtract;
    }

    @Override
    public boolean doesCharge(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? false : ((CosmosEnergyArmourItemColourable)item).doesCharge;
    }

    @Override
    public boolean doesDisplayEnergyInTooltip(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyArmourItemColourable) ? false : ((CosmosEnergyArmourItemColourable)item).doesDisplayEnergyInTooltip;
    }

    @Override
    public boolean canReceiveEnergy(ItemStack stackIn) {
        return this.getEnergy(stackIn) < this.getMaxEnergyStored(stackIn);
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, int scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, float scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public int receiveEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canReceiveEnergy(stackIn) && this.doesCharge(stackIn)) {
            int storedReceived = Math.min(this.getMaxEnergyStored(stackIn) - this.getEnergy(stackIn), Math.min(this.getMaxReceive(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) + storedReceived);
            }
            return storedReceived;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canExtractEnergy(stackIn) && this.doesExtract(stackIn)) {
            int storedExtracted = Math.min(this.getEnergy(stackIn), Math.min(this.getMaxExtract(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) - storedExtracted);
            }
            return storedExtracted;
        }
        return 0;
    }

    public boolean m_142522_(ItemStack stackIn) {
        return true;
    }

    public int m_142159_(ItemStack stackIn) {
        return this.barColour.dec();
    }

    public int m_142158_(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof ICosmosEnergyItem) ? 0 : Mth.m_14045_((int)Math.round((float)((ICosmosEnergyItem)item).getScaledEnergy(stackIn, 13)), (int)0, (int)13);
    }
}

