/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.energy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.energy.interfaces.ICosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class CosmosEnergyBow
extends BowItem
implements ICosmosEnergyItem {
    private int maxEnergyStored;
    private int maxExtract;
    private int maxReceive;
    private int maxUse;
    private boolean doesExtract;
    private boolean doesCharge;
    private boolean doesDisplayEnergyInTooltip;
    private ComponentColour barColour;
    private int range;
    private int knockbackModifier;
    private float damageModifier;
    private float powerModifier;

    public CosmosEnergyBow(Item.Properties builder, CosmosEnergyItem.Properties energyProperties, int rangeIn, int knockbackModifierIn, float powerModifierIn, float damageModifierIn) {
        super(builder.m_41487_(1));
        this.maxEnergyStored = energyProperties.maxEnergyStored;
        this.maxExtract = energyProperties.maxExtract;
        this.maxReceive = energyProperties.maxReceive;
        this.maxUse = energyProperties.maxUse;
        this.doesExtract = energyProperties.doesExtract;
        this.doesCharge = energyProperties.doesCharge;
        this.doesDisplayEnergyInTooltip = energyProperties.doesDisplayEnergyInTooltip;
        this.barColour = energyProperties.barColour;
        this.range = rangeIn;
        this.damageModifier = damageModifierIn;
        this.knockbackModifier = knockbackModifierIn;
        this.powerModifier = powerModifierIn;
    }

    public void m_7373_(ItemStack stackIn, @Nullable Level worldIn, List<Component> toolTipIn, TooltipFlag flagIn) {
        super.m_7373_(stackIn, worldIn, toolTipIn, flagIn);
        if (stackIn.m_41782_()) {
            CompoundTag stackTag = stackIn.m_41783_();
            toolTipIn.add((Component)ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.tooltip.energy_item.stored").m_7220_((Component)ComponentHelper.comp("\u00a77[ \u00a74" + CosmosUtil.formatIntegerMillion(stackTag.m_128451_("energy")) + "\u00a77 / \u00a74" + CosmosUtil.formatIntegerMillion(this.getMaxEnergyStored(stackIn)) + "\u00a77 ]")));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotIn, ItemStack stackIn) {
        if (!this.hasEnergy(stackIn)) {
            return ImmutableMultimap.of();
        }
        return this.m_7167_(slotIn);
    }

    public int m_8105_(ItemStack stackIn) {
        return 72000;
    }

    public int m_6615_() {
        return this.range;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack;
        boolean flag = !playerIn.m_6298_(itemstack = playerIn.m_21120_(handIn)).m_41619_();
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)levelIn, (Player)playerIn, (InteractionHand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (this.hasEnergy(itemstack)) {
            if (!playerIn.m_150110_().f_35937_ && !flag) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5551_(ItemStack stackIn, Level worldIn, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            Player playerentity = (Player)livingEntity;
            boolean flag = playerentity.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stackIn) > 0;
            ItemStack itemstack = playerentity.m_6298_(stackIn);
            int i = this.m_8105_(stackIn) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stackIn, (Level)worldIn, (Player)playerentity, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                float f;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(f = CosmosEnergyBow.m_40661_((int)i)) < 0.1)) {
                    boolean flag1;
                    boolean bl = flag1 = playerentity.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, stackIn, playerentity);
                    if (!worldIn.f_46443_) {
                        int k;
                        int j;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow abstractarrowentity = arrowitem.m_6394_(worldIn, itemstack, (LivingEntity)playerentity);
                        abstractarrowentity = this.customArrow(abstractarrowentity);
                        abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_(), 0.0f, f * 3.0f * this.powerModifier, 1.0f);
                        if (f == 1.0f) {
                            abstractarrowentity.m_36762_(true);
                        }
                        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stackIn)) > 0) {
                            abstractarrowentity.m_36781_((abstractarrowentity.m_36789_() + ((double)j * 0.5 + 0.5)) * (double)this.damageModifier);
                        }
                        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stackIn)) > 0) {
                            abstractarrowentity.m_36735_(k * this.knockbackModifier);
                        }
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stackIn) > 0) {
                            abstractarrowentity.m_20254_(100);
                        }
                        this.extractEnergy(stackIn, this.getMaxUse(stackIn) / 2, false);
                        if (flag1 || playerentity.m_150110_().f_35937_ && (itemstack.m_41720_() == Items.f_42737_ || itemstack.m_41720_() == Items.f_42738_)) {
                            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        worldIn.m_7967_((Entity)abstractarrowentity);
                    }
                    worldIn.m_6263_((Player)null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.f_46441_.m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!flag1 && !playerentity.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            playerentity.m_150109_().m_36057_(itemstack);
                        }
                    }
                    playerentity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? 0 : ((CosmosEnergyBow)item).maxEnergyStored;
    }

    @Override
    public int getMaxExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? 0 : ((CosmosEnergyBow)item).maxExtract;
    }

    @Override
    public int getMaxReceive(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? 0 : ((CosmosEnergyBow)item).maxReceive;
    }

    @Override
    public int getMaxUse(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? 0 : ((CosmosEnergyBow)item).maxUse;
    }

    @Override
    public boolean doesExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? false : ((CosmosEnergyBow)item).doesExtract;
    }

    @Override
    public boolean doesCharge(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? false : ((CosmosEnergyBow)item).doesCharge;
    }

    @Override
    public boolean doesDisplayEnergyInTooltip(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyBow) ? false : ((CosmosEnergyBow)item).doesDisplayEnergyInTooltip;
    }

    @Override
    public boolean canReceiveEnergy(ItemStack stackIn) {
        return this.getEnergy(stackIn) < this.getMaxEnergyStored(stackIn);
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, int scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, float scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public int receiveEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canReceiveEnergy(stackIn) && this.doesCharge(stackIn)) {
            int storedReceived = Math.min(this.getMaxEnergyStored(stackIn) - this.getEnergy(stackIn), Math.min(this.getMaxReceive(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) + storedReceived);
            }
            return storedReceived;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canExtractEnergy(stackIn) && this.doesExtract(stackIn)) {
            int storedExtracted = Math.min(this.getEnergy(stackIn), Math.min(this.getMaxExtract(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) - storedExtracted);
            }
            return storedExtracted;
        }
        return 0;
    }

    public boolean m_142522_(ItemStack stackIn) {
        return true;
    }

    public int m_142159_(ItemStack stackIn) {
        return this.barColour.dec();
    }

    public int m_142158_(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof ICosmosEnergyItem) ? 0 : Mth.m_14045_((int)Math.round((float)((ICosmosEnergyItem)item).getScaledEnergy(stackIn, 13)), (int)0, (int)13);
    }
}

