/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.energy.item;

import com.tcn.cosmoslibrary.common.item.CosmosItem;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.energy.interfaces.ICosmosEnergyItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CosmosEnergyItem
extends CosmosItem
implements ICosmosEnergyItem {
    private int maxEnergyStored;
    private int maxExtract;
    private int maxReceive;
    private int maxUse;
    private boolean doesExtract;
    private boolean doesCharge;
    private boolean doesDisplayEnergyInTooltip;
    private ComponentColour barColour;

    public CosmosEnergyItem(Item.Properties properties, Properties energyProperties) {
        super(properties);
        this.maxEnergyStored = energyProperties.maxEnergyStored;
        this.maxExtract = energyProperties.maxExtract;
        this.maxReceive = energyProperties.maxReceive;
        this.maxUse = energyProperties.maxUse;
        this.doesExtract = energyProperties.doesExtract;
        this.doesCharge = energyProperties.doesCharge;
        this.doesDisplayEnergyInTooltip = energyProperties.doesDisplayEnergyInTooltip;
        this.barColour = energyProperties.barColour;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            CompoundTag stackTag = stack.m_41783_();
            tooltip.add((Component)ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.tooltip.energy_item.stored").m_7220_((Component)ComponentHelper.comp("\u00a77[ \u00a74" + CosmosUtil.formatIntegerMillion(stackTag.m_128451_("energy")) + "\u00a77 / \u00a74" + CosmosUtil.formatIntegerMillion(this.getMaxEnergyStored(stack)) + "\u00a77 ]")));
        }
    }

    @Override
    public int getMaxEnergyStored(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? 0 : ((CosmosEnergyItem)item).maxEnergyStored;
    }

    @Override
    public int getMaxExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? 0 : ((CosmosEnergyItem)item).maxExtract;
    }

    @Override
    public int getMaxReceive(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? 0 : ((CosmosEnergyItem)item).maxReceive;
    }

    @Override
    public int getMaxUse(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? 0 : ((CosmosEnergyItem)item).maxUse;
    }

    @Override
    public boolean doesExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? false : ((CosmosEnergyItem)item).doesExtract;
    }

    @Override
    public boolean doesCharge(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? false : ((CosmosEnergyItem)item).doesCharge;
    }

    @Override
    public boolean doesDisplayEnergyInTooltip(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyItem) ? false : ((CosmosEnergyItem)item).doesDisplayEnergyInTooltip;
    }

    @Override
    public boolean canReceiveEnergy(ItemStack stackIn) {
        return this.getEnergy(stackIn) < this.getMaxEnergyStored(stackIn);
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, int scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, float scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public int receiveEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canReceiveEnergy(stackIn) && this.doesCharge(stackIn)) {
            int storedReceived = Math.min(this.getMaxEnergyStored(stackIn) - this.getEnergy(stackIn), Math.min(this.getMaxReceive(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) + storedReceived);
            }
            return storedReceived;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canExtractEnergy(stackIn) && this.doesExtract(stackIn)) {
            int storedExtracted = Math.min(this.getEnergy(stackIn), Math.min(this.getMaxExtract(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) - storedExtracted);
            }
            return storedExtracted;
        }
        return 0;
    }

    public boolean m_142522_(ItemStack stackIn) {
        return true;
    }

    public int m_142159_(ItemStack stackIn) {
        return this.barColour.dec();
    }

    public int m_142158_(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof ICosmosEnergyItem) ? 0 : Mth.m_14045_((int)Math.round((float)((ICosmosEnergyItem)item).getScaledEnergy(stackIn, 13)), (int)0, (int)13);
    }

    public static class Properties {
        public int maxEnergyStored = 0;
        public int maxExtract = 0;
        public int maxReceive = 0;
        public int maxUse = 0;
        public boolean doesExtract = true;
        public boolean doesCharge = true;
        public boolean doesDisplayEnergyInTooltip = true;
        public ComponentColour barColour = ComponentColour.RED;

        public Properties maxEnergyStored(int valueIn) {
            this.maxEnergyStored = valueIn;
            return this;
        }

        public Properties maxExtract(int valueIn) {
            this.maxExtract = valueIn;
            return this;
        }

        public Properties maxReceive(int valueIn) {
            this.maxReceive = valueIn;
            return this;
        }

        public Properties maxUse(int value) {
            this.maxUse = value;
            return this;
        }

        public Properties maxIO(int valueIn) {
            this.maxExtract = valueIn;
            this.maxReceive = valueIn;
            return this;
        }

        public Properties doesExtract(boolean valueIn) {
            this.doesExtract = valueIn;
            return this;
        }

        public Properties doesCharge(boolean valueIn) {
            this.doesCharge = valueIn;
            return this;
        }

        public Properties doesDisplayEnergyInTooltip(boolean valueIn) {
            this.doesDisplayEnergyInTooltip = valueIn;
            return this;
        }

        public Properties barColour(ComponentColour colourIn) {
            this.barColour = colourIn;
            return this;
        }

        public Properties setStatsFromArray(int[] array) {
            this.maxEnergyStored = array[0];
            this.maxExtract = array[1];
            this.maxReceive = array[1];
            this.maxUse = array[2];
            return this;
        }
    }
}

