/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.energy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.tcn.cosmoslibrary.client.renderer.item.CosmosShieldBEWLR;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.energy.interfaces.ICosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class CosmosEnergyShield
extends ShieldItem
implements ICosmosEnergyItem {
    public static final int EFFECTIVE_BLOCK_DELAY = 5;
    public static final float MINIMUM_DURABILITY_DAMAGE = 3.0f;
    public static final String TAG_BASE_COLOR = "Base";
    private int maxEnergyStored;
    private int maxExtract;
    private int maxReceive;
    private int maxUse;
    private boolean doesExtract;
    private boolean doesCharge;
    private boolean doesDisplayEnergyInTooltip;
    private ComponentColour barColour;
    private ResourceLocation normal;
    private ResourceLocation noPattern;

    public CosmosEnergyShield(Item.Properties properties, CosmosEnergyItem.Properties energyProperties, ResourceLocation normalIn, ResourceLocation noPatternIn) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
        this.maxEnergyStored = energyProperties.maxEnergyStored;
        this.maxExtract = energyProperties.maxExtract;
        this.maxReceive = energyProperties.maxReceive;
        this.maxUse = energyProperties.maxUse;
        this.doesExtract = energyProperties.doesExtract;
        this.doesCharge = energyProperties.doesCharge;
        this.doesDisplayEnergyInTooltip = energyProperties.doesDisplayEnergyInTooltip;
        this.barColour = energyProperties.barColour;
        this.normal = normalIn;
        this.noPattern = noPatternIn;
    }

    public int m_6473_() {
        return 1;
    }

    public String m_5671_(ItemStack stackIn) {
        return BlockItem.m_186336_((ItemStack)stackIn) != null ? this.m_5524_() + "." + CosmosEnergyShield.m_43102_(stackIn).m_41065_() : super.m_5671_(stackIn);
    }

    public void m_7373_(ItemStack stackIn, @Nullable Level levelIn, List<Component> tooltipIn, TooltipFlag flagIn) {
        BannerItem.m_40542_((ItemStack)stackIn, tooltipIn);
        if (stackIn.m_41782_()) {
            CompoundTag stackTag = stackIn.m_41783_();
            tooltipIn.add((Component)ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.tooltip.energy_item.stored").m_7220_((Component)ComponentHelper.comp("\u00a77[ \u00a74" + CosmosUtil.formatIntegerMillion(stackTag.m_128451_("energy")) + "\u00a77 / \u00a74" + CosmosUtil.formatIntegerMillion(this.getMaxEnergyStored(stackIn)) + "\u00a77 ]")));
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new CosmosShieldBEWLR(CosmosEnergyShield.this.normal, CosmosEnergyShield.this.noPattern);
            }
        });
    }

    public UseAnim m_6164_(ItemStack stackIn) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stackIn) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (this.hasEnergy(itemstack)) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stackIn, int amount, T entity, Consumer<T> onBroken) {
        if (this.getDamage(stackIn) < this.getMaxDamage(stackIn)) {
            this.setDamage(stackIn, 0);
        }
        if (this.hasEnergy(stackIn)) {
            this.extractEnergy(stackIn, this.getMaxUse(stackIn), false);
        }
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotIn, ItemStack stackIn) {
        if (!this.hasEnergy(stackIn)) {
            return ImmutableMultimap.of();
        }
        return this.m_7167_(slotIn);
    }

    public boolean m_6832_(ItemStack stackIn, ItemStack repairStackIn) {
        return false;
    }

    public static DyeColor m_43102_(ItemStack stackIn) {
        CompoundTag compoundtag = BlockItem.m_186336_((ItemStack)stackIn);
        return compoundtag != null ? DyeColor.m_41053_((int)compoundtag.m_128451_(TAG_BASE_COLOR)) : DyeColor.WHITE;
    }

    public boolean canPerformAction(ItemStack stackIn, ToolAction toolAction) {
        if (this.hasEnergy(stackIn)) {
            return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
        }
        return false;
    }

    @Override
    public int getMaxEnergyStored(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? 0 : ((CosmosEnergyShield)item).maxEnergyStored;
    }

    @Override
    public int getMaxExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? 0 : ((CosmosEnergyShield)item).maxExtract;
    }

    @Override
    public int getMaxReceive(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? 0 : ((CosmosEnergyShield)item).maxReceive;
    }

    @Override
    public int getMaxUse(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? 0 : ((CosmosEnergyShield)item).maxUse;
    }

    @Override
    public boolean doesExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? false : ((CosmosEnergyShield)item).doesExtract;
    }

    @Override
    public boolean doesCharge(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? false : ((CosmosEnergyShield)item).doesCharge;
    }

    @Override
    public boolean doesDisplayEnergyInTooltip(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergyShield) ? false : ((CosmosEnergyShield)item).doesDisplayEnergyInTooltip;
    }

    @Override
    public boolean canReceiveEnergy(ItemStack stackIn) {
        return this.getEnergy(stackIn) < this.getMaxEnergyStored(stackIn);
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, int scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, float scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public int receiveEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canReceiveEnergy(stackIn) && this.doesCharge(stackIn)) {
            int storedReceived = Math.min(this.getMaxEnergyStored(stackIn) - this.getEnergy(stackIn), Math.min(this.getMaxReceive(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) + storedReceived);
            }
            return storedReceived;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canExtractEnergy(stackIn) && this.doesExtract(stackIn)) {
            int storedExtracted = Math.min(this.getEnergy(stackIn), Math.min(this.getMaxExtract(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) - storedExtracted);
            }
            return storedExtracted;
        }
        return 0;
    }

    public boolean m_142522_(ItemStack stackIn) {
        return true;
    }

    public int m_142159_(ItemStack stackIn) {
        return this.barColour.dec();
    }

    public int m_142158_(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof ICosmosEnergyItem) ? 0 : Mth.m_14045_((int)Math.round((float)((ICosmosEnergyItem)item).getScaledEnergy(stackIn, 13)), (int)0, (int)13);
    }
}

