/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.energy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.tcn.cosmoslibrary.common.lib.ComponentColour;
import com.tcn.cosmoslibrary.common.lib.ComponentHelper;
import com.tcn.cosmoslibrary.common.util.CosmosUtil;
import com.tcn.cosmoslibrary.energy.interfaces.ICosmosEnergyItem;
import com.tcn.cosmoslibrary.energy.item.CosmosEnergyItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CosmosEnergySword
extends SwordItem
implements ICosmosEnergyItem {
    private int maxEnergyStored;
    private int maxExtract;
    private int maxReceive;
    private int maxUse;
    private boolean doesExtract;
    private boolean doesCharge;
    private boolean doesDisplayEnergyInTooltip;
    private ComponentColour barColour;

    public CosmosEnergySword(Tier itemTier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn, CosmosEnergyItem.Properties energyProperties) {
        super(itemTier, attackDamageIn, attackSpeedIn, builderIn);
        this.maxEnergyStored = energyProperties.maxEnergyStored;
        this.maxExtract = energyProperties.maxExtract;
        this.maxReceive = energyProperties.maxReceive;
        this.maxUse = energyProperties.maxUse;
        this.doesExtract = energyProperties.doesExtract;
        this.doesCharge = energyProperties.doesCharge;
        this.doesDisplayEnergyInTooltip = energyProperties.doesDisplayEnergyInTooltip;
        this.barColour = energyProperties.barColour;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            CompoundTag stackTag = stack.m_41783_();
            tooltip.add((Component)ComponentHelper.style(ComponentColour.GRAY, "cosmoslibrary.tooltip.energy_item.stored").m_7220_((Component)ComponentHelper.comp("\u00a77[ \u00a74" + CosmosUtil.formatIntegerMillion(stackTag.m_128451_("energy")) + "\u00a77 / \u00a74" + CosmosUtil.formatIntegerMillion(this.getMaxEnergyStored(stack)) + "\u00a77 ]")));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotIn, ItemStack stackIn) {
        if (!this.hasEnergy(stackIn)) {
            return ImmutableMultimap.of();
        }
        return this.m_7167_(slotIn);
    }

    public boolean m_6777_(BlockState stateIn, Level worldIn, BlockPos posIn, Player playerEntity) {
        ItemStack heldStack = playerEntity.m_150109_().m_36056_();
        return heldStack.m_41720_() instanceof CosmosEnergySword && !playerEntity.m_7500_() && this.hasEnergy(heldStack);
    }

    public boolean m_7579_(ItemStack stackIn, LivingEntity target, LivingEntity attacker) {
        if (this.hasEnergy(stackIn)) {
            this.extractEnergy(stackIn, this.getMaxUse(stackIn), false);
            return true;
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stackIn, Player player, Entity entity) {
        return !this.hasEnergy(stackIn);
    }

    public boolean onEntitySwing(ItemStack stackIn, LivingEntity entity) {
        return !this.hasEnergy(stackIn);
    }

    public boolean m_6813_(ItemStack stackIn, Level worldIn, BlockState blockStateIn, BlockPos posIn, LivingEntity entityLiving) {
        if (this.hasEnergy(stackIn)) {
            this.extractEnergy(stackIn, this.getMaxUse(stackIn) / 2, false);
            return true;
        }
        return false;
    }

    @Override
    public int getMaxEnergyStored(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? 0 : ((CosmosEnergySword)item).maxEnergyStored;
    }

    @Override
    public int getMaxExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? 0 : ((CosmosEnergySword)item).maxExtract;
    }

    @Override
    public int getMaxReceive(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? 0 : ((CosmosEnergySword)item).maxReceive;
    }

    @Override
    public int getMaxUse(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? 0 : ((CosmosEnergySword)item).maxUse;
    }

    @Override
    public boolean doesExtract(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? false : ((CosmosEnergySword)item).doesExtract;
    }

    @Override
    public boolean doesCharge(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? false : ((CosmosEnergySword)item).doesCharge;
    }

    @Override
    public boolean doesDisplayEnergyInTooltip(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof CosmosEnergySword) ? false : ((CosmosEnergySword)item).doesDisplayEnergyInTooltip;
    }

    @Override
    public boolean canReceiveEnergy(ItemStack stackIn) {
        return this.getEnergy(stackIn) < this.getMaxEnergyStored(stackIn);
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, int scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public double getScaledEnergy(ItemStack stackIn, float scaleIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof ICosmosEnergyItem) {
            return (double)this.getEnergy(stackIn) * (double)scaleIn / (double)this.getMaxEnergyStored(stackIn);
        }
        return 0.0;
    }

    @Override
    public int receiveEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canReceiveEnergy(stackIn) && this.doesCharge(stackIn)) {
            int storedReceived = Math.min(this.getMaxEnergyStored(stackIn) - this.getEnergy(stackIn), Math.min(this.getMaxReceive(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) + storedReceived);
            }
            return storedReceived;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack stackIn, int energy, boolean simulate) {
        if (this.canExtractEnergy(stackIn) && this.doesExtract(stackIn)) {
            int storedExtracted = Math.min(this.getEnergy(stackIn), Math.min(this.getMaxExtract(stackIn), energy));
            if (!simulate) {
                this.setEnergy(stackIn, this.getEnergy(stackIn) - storedExtracted);
            }
            return storedExtracted;
        }
        return 0;
    }

    public boolean m_142522_(ItemStack stackIn) {
        return true;
    }

    public int m_142159_(ItemStack stackIn) {
        return this.barColour.dec();
    }

    public int m_142158_(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        return !(item instanceof ICosmosEnergyItem) ? 0 : Mth.m_14045_((int)Math.round((float)((ICosmosEnergyItem)item).getScaledEnergy(stackIn, 13)), (int)0, (int)13);
    }
}

