/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.registry.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.tcn.cosmoslibrary.common.enums.EnumConnectionType;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectConnectionType;
import java.lang.reflect.Type;
import net.minecraft.core.BlockPos;

public class GsonAdapterConnectionType
implements JsonSerializer<ObjectConnectionType>,
JsonDeserializer<ObjectConnectionType> {
    private static final String NBT_BLOCKPOS_KEY = "block_pos";
    private static final String NBT_TYPE_KEY = "type";

    public ObjectConnectionType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        JsonObject block_pos = object.getAsJsonObject(NBT_BLOCKPOS_KEY);
        int x = block_pos.get("x").getAsInt();
        int y = block_pos.get("y").getAsInt();
        int z = block_pos.get("z").getAsInt();
        BlockPos pos = new BlockPos(x, y, z);
        String name = object.get(NBT_TYPE_KEY).getAsString();
        EnumConnectionType type = EnumConnectionType.getStateFromName(name);
        return new ObjectConnectionType(pos, type);
    }

    public JsonElement serialize(ObjectConnectionType src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonObject block_pos = new JsonObject();
        BlockPos pos = src.getPos();
        block_pos.addProperty("x", (Number)pos.m_123341_());
        block_pos.addProperty("y", (Number)pos.m_123342_());
        block_pos.addProperty("z", (Number)pos.m_123343_());
        object.addProperty(NBT_TYPE_KEY, src.getType().getName());
        object.add(NBT_BLOCKPOS_KEY, (JsonElement)block_pos);
        return object;
    }
}

