/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.registry.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.tcn.cosmoslibrary.registry.gson.object.ObjectFluidTankCustom;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;

public class GsonAdapterFluidTankCustom
implements JsonSerializer<ObjectFluidTankCustom>,
JsonDeserializer<ObjectFluidTankCustom> {
    private static final String NBT_FLUID_KEY = "fluid";
    private static final String NBT_FILL_LEVEL_KEY = "fill_level";
    private static final String NBT_FLUID_CAPACITY_KEY = "capacity";
    private static final String NBT_FLUID_VOLUME_KEY = "volume";

    public ObjectFluidTankCustom deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        JsonObject fluid = object.getAsJsonObject(NBT_FLUID_KEY);
        int capacity = object.get(NBT_FLUID_CAPACITY_KEY).getAsInt();
        int volume = object.get(NBT_FLUID_VOLUME_KEY).getAsInt();
        int fill_level = object.get(NBT_FILL_LEVEL_KEY).getAsInt();
        FluidTank tank = new FluidTank(capacity);
        String namespace = fluid.get("namespace").getAsString();
        String path = fluid.get("path").getAsString();
        ResourceLocation fluidName = new ResourceLocation(namespace, path);
        tank.setFluid(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidName), volume));
        return new ObjectFluidTankCustom(tank, fill_level);
    }

    public JsonElement serialize(ObjectFluidTankCustom src, Type typeOfSrc, JsonSerializationContext context) {
        ResourceLocation fluid_name = new ResourceLocation(src.getFluidTank().getFluid().getFluid().getFluidType().getDescriptionId());
        JsonObject object = new JsonObject();
        JsonObject fluid = new JsonObject();
        fluid.addProperty("namespace", fluid_name.m_135827_());
        fluid.addProperty("path", fluid_name.m_135815_());
        object.addProperty(NBT_FILL_LEVEL_KEY, (Number)src.getFillLevel());
        object.addProperty(NBT_FLUID_CAPACITY_KEY, (Number)src.getFluidTank().getCapacity());
        object.addProperty(NBT_FLUID_VOLUME_KEY, (Number)src.getFluidTank().getFluidAmount());
        object.add(NBT_FLUID_KEY, (JsonElement)fluid);
        return object;
    }
}

