/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.registry.gson.object;

import com.tcn.cosmoslibrary.common.enums.EnumConnectionType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ObjectConnectionType {
    private static final String NBT_TYPE_KEY = "type";
    private BlockPos pos;
    private EnumConnectionType type;

    public ObjectConnectionType(BlockPos posIn, EnumConnectionType typeIn) {
        this.setPos(posIn);
        this.setType(typeIn);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public EnumConnectionType getType() {
        return this.type;
    }

    public void setType(EnumConnectionType type) {
        this.type = type;
    }

    public static ObjectConnectionType readFromNBT(CompoundTag compound) {
        CompoundTag block_pos = compound.m_128469_("pos");
        int x = block_pos.m_128451_("x");
        int y = block_pos.m_128451_("y");
        int z = block_pos.m_128451_("z");
        BlockPos pos = new BlockPos(x, y, z);
        String s = compound.m_128461_(NBT_TYPE_KEY);
        EnumConnectionType type = EnumConnectionType.getStateFromName(s);
        return new ObjectConnectionType(pos, type);
    }

    public void writeToNBT(CompoundTag compound) {
        String name = this.getType().getName();
        compound.m_128359_(NBT_TYPE_KEY, name);
        int x = this.getPos().m_123341_();
        int y = this.getPos().m_123342_();
        int z = this.getPos().m_123343_();
        CompoundTag block_pos = new CompoundTag();
        block_pos.m_128405_("x", x);
        block_pos.m_128405_("y", y);
        block_pos.m_128405_("z", z);
        compound.m_128365_("pos", (Tag)block_pos);
    }
}

