/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.registry.gson.object;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ObjectFluidTankCustom {
    private static final String NBT_FLUID_KEY = "fluid_tank_object";
    private static final String NBT_FILL_LEVEL_KEY = "fill_level";
    private static final String NBT_FLUID_CAPACITY_KEY = "capacity";
    private static final String NBT_FLUID_VOLUME_KEY = "volume";
    private FluidTank fluid_tank;
    private int fill_level;

    private ObjectFluidTankCustom() {
    }

    public ObjectFluidTankCustom(FluidTank fluid_tank, int fill_level) {
        this.fluid_tank = fluid_tank;
        this.fill_level = fill_level;
    }

    public FluidTank getFluidTank() {
        return this.fluid_tank;
    }

    public void setFluidTank(FluidTank player_name) {
        this.fluid_tank = player_name;
    }

    public int getFillLevel() {
        return this.fill_level;
    }

    public void setFillLevel(int fill_level) {
        this.fill_level = fill_level;
    }

    public static ObjectFluidTankCustom readFromNBT(CompoundTag compound) {
        int capacity = compound.m_128451_(NBT_FLUID_CAPACITY_KEY);
        int volume = compound.m_128451_(NBT_FLUID_VOLUME_KEY);
        int fill_level = compound.m_128451_(NBT_FILL_LEVEL_KEY);
        FluidTank tank = new FluidTank(capacity).setCapacity(capacity);
        CompoundTag fluid = compound.m_128469_(NBT_FLUID_KEY);
        String namespace = fluid.m_128461_("namespace");
        String path = fluid.m_128461_("path");
        ResourceLocation fluidName = new ResourceLocation(namespace, path);
        tank.setFluid(new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidName), volume));
        return new ObjectFluidTankCustom(tank, fill_level);
    }

    public void writeToNBT(CompoundTag compound) {
        ResourceLocation fluid_name = ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getKey((Object)this.fluid_tank.getFluid().getFluid().getFluidType());
        CompoundTag fluid = new CompoundTag();
        fluid.m_128359_("namespace", fluid_name.m_135827_());
        fluid.m_128359_("path", fluid_name.m_135815_());
        compound.m_128405_(NBT_FILL_LEVEL_KEY, this.getFillLevel());
        compound.m_128405_(NBT_FLUID_CAPACITY_KEY, this.getFluidTank().getCapacity());
        compound.m_128405_(NBT_FLUID_VOLUME_KEY, this.getFluidTank().getFluidAmount());
        compound.m_128365_(NBT_FLUID_KEY, (Tag)fluid);
    }
}

