/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.runtime.network;

import com.tcn.cosmoslibrary.CosmosLibrary;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.container.CosmosContainerRecipeBookBlockEntity;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBlockEntityUIMode;
import com.tcn.cosmoslibrary.runtime.network.ICosmosPacket;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PacketUIHelp
implements ICosmosPacket {
    private BlockPos pos;
    private ResourceKey<Level> dimension;

    public PacketUIHelp(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        ResourceLocation location = buf.m_130281_();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
    }

    public PacketUIHelp(CosmosContainerMenuBlockEntity containerIn) {
        this.pos = containerIn.getBlockPos();
        this.dimension = containerIn.getLevel().m_46472_();
    }

    public PacketUIHelp(CosmosContainerRecipeBookBlockEntity<? extends Container> containerIn) {
        this.pos = containerIn.getBlockPos();
        this.dimension = containerIn.getLevel().m_46472_();
    }

    public static void encode(PacketUIHelp packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130085_(packet.dimension.m_135782_());
    }

    public static void handle(PacketUIHelp packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel world = server.m_129880_(packet.dimension);
            BlockEntity entity = world.m_7702_(packet.pos);
            if (entity instanceof IBlockEntityUIMode) {
                IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
                blockEntity.cycleUIHelp();
            } else {
                CosmosLibrary.CONSOLE.debugWarn("[Packet Delivery Failure] <uihelp> Block Entity not equal to expected.");
            }
        });
        ctx.setPacketHandled(true);
    }
}

