/*
 * Decompiled with CFR 0.152.
 */
package com.tcn.cosmoslibrary.runtime.network;

import com.tcn.cosmoslibrary.CosmosLibrary;
import com.tcn.cosmoslibrary.client.container.CosmosContainerMenuBlockEntity;
import com.tcn.cosmoslibrary.client.container.CosmosContainerRecipeBookBlockEntity;
import com.tcn.cosmoslibrary.common.interfaces.blockentity.IBlockEntityUIMode;
import com.tcn.cosmoslibrary.runtime.network.ICosmosPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PacketUILock
implements ICosmosPacket {
    private BlockPos pos;
    private ResourceKey<Level> dimension;
    private UUID uuid;

    public PacketUILock(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        ResourceLocation location = buf.m_130281_();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
        this.uuid = buf.m_130259_();
    }

    public PacketUILock(CosmosContainerMenuBlockEntity containerIn) {
        this.pos = containerIn.getBlockPos();
        this.dimension = containerIn.getLevel().m_46472_();
        this.uuid = containerIn.getPlayer().m_20148_();
    }

    public PacketUILock(CosmosContainerRecipeBookBlockEntity<? extends Container> containerIn) {
        this.pos = containerIn.getBlockPos();
        this.dimension = containerIn.getLevel().m_46472_();
        this.uuid = containerIn.getPlayer().m_20148_();
    }

    public static void encode(PacketUILock packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.m_130085_(packet.dimension.m_135782_());
        buf.m_130077_(packet.uuid);
    }

    public static void handle(PacketUILock packet, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel world = server.m_129880_(packet.dimension);
            BlockEntity entity = world.m_7702_(packet.pos);
            Player player = world.m_46003_(packet.uuid);
            if (entity instanceof IBlockEntityUIMode) {
                IBlockEntityUIMode blockEntity = (IBlockEntityUIMode)entity;
                if (blockEntity.checkIfOwner(player)) {
                    blockEntity.cycleUILock();
                }
            } else {
                CosmosLibrary.CONSOLE.debugWarn("[Packet Delivery Failure] <uilock> Block Entity not equal to expected.");
            }
        });
        ctx.setPacketHandled(true);
    }
}

