/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.processing.AssemblyOperatorUseContext;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DeployerBlock
extends DirectionalAxisKineticBlock
implements IBE<DeployerBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public DeployerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.DEPLOYER_INTERACTION.get((Direction)state.m_61143_((Property)FACING));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.m_61143_((Property)FACING));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Vec3 normal = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122436_());
        Vec3 location = context.m_43720_().m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()).m_82546_(normal.m_82490_(0.5))).m_82559_(normal);
        if (location.m_82553_() > 0.75) {
            if (!context.m_43725_().f_46443_) {
                this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), DeployerBlockEntity::changeMode);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onWrenched(state, context);
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer instanceof ServerPlayer) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, dbe -> {
                dbe.owner = placer.m_20148_();
            });
        }
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, DeployerBlockEntity::discardPlayer);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldByPlayer = player.m_21120_(handIn).m_41777_();
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(heldByPlayer) && placementHelper.getOffset(player, worldIn, state, pos, hit).placeInWorld(worldIn, (BlockItem)heldByPlayer.m_41720_(), player, handIn, hit).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (AllItems.WRENCH.isIn(heldByPlayer)) {
            return InteractionResult.PASS;
        }
        Vec3 normal = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122436_());
        Vec3 location = hit.m_82450_().m_82546_(Vec3.m_82512_((Vec3i)pos).m_82546_(normal.m_82490_(0.5))).m_82559_(normal);
        if (location.m_82553_() < 0.75) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            ItemStack heldByDeployer = be.player.m_21205_().m_41777_();
            if (heldByDeployer.m_41619_() && heldByPlayer.m_41619_()) {
                return;
            }
            player.m_21008_(handIn, heldByDeployer);
            be.player.m_21008_(InteractionHand.MAIN_HAND, heldByPlayer);
            be.sendData();
        });
        return InteractionResult.SUCCESS;
    }

    @Override
    public Class<DeployerBlockEntity> getBlockEntityClass() {
        return DeployerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends DeployerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.DEPLOYER.get();
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        this.withBlockEntityDo((BlockGetter)world, pos, DeployerBlockEntity::redstoneUpdate);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        this.withBlockEntityDo((BlockGetter)world, pos, DeployerBlockEntity::redstoneUpdate);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    protected Direction getFacingForPlacement(BlockPlaceContext context) {
        if (context instanceof AssemblyOperatorUseContext) {
            return Direction.DOWN;
        }
        return super.getFacingForPlacement(context);
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.DEPLOYER.isIn(arg_0);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> AllBlocks.DEPLOYER.has(arg_0);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), ((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_(), (Direction dir) -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_(directions.get(0)), s -> (BlockState)((BlockState)s.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)))).m_61124_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE))));
        }
    }
}

