/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gauge;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedGaugeBlockEntity
extends GaugeBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;

    public SpeedGaugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        float speed = Math.abs(this.getSpeed());
        this.dialTarget = SpeedGaugeBlockEntity.getDialTarget(speed);
        this.color = Color.mixColors(IRotate.SpeedLevel.of(speed).getColor(), 0xFFFFFF, 0.25f);
        this.m_6596_();
    }

    public static float getDialTarget(float speed) {
        speed = Math.abs(speed);
        float medium = ((Double)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
        float fast = ((Double)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
        float max = ((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).floatValue();
        float target = 0.0f;
        target = speed == 0.0f ? 0.0f : (speed < medium ? Mth.m_14179_((float)(speed / medium), (float)0.0f, (float)0.45f) : (speed < fast ? Mth.m_14179_((float)((speed - medium) / (fast - medium)), (float)0.45f, (float)0.75f) : Mth.m_14179_((float)((speed - fast) / (max - fast)), (float)0.75f, (float)1.125f)));
        return target;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        Lang.translate("gui.speedometer.title", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText(this.speed, this.isOverStressed()).forGoggles(tooltip);
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.computerBehaviour.isPeripheralCap(cap)) {
            return this.computerBehaviour.getPeripheralCapability();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.computerBehaviour.removePeripheral();
    }
}

