/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace;

import com.mojang.logging.LogUtils;
import com.rae.creatingspace.CSDatagen;
import com.rae.creatingspace.CreatingSpaceClient;
import com.rae.creatingspace.api.design.ExhaustPackType;
import com.rae.creatingspace.api.design.PowerPackType;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.api.planets.RocketAccessibleDimension;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.init.CreativeModeTabsInit;
import com.rae.creatingspace.init.EntityDataSerializersInit;
import com.rae.creatingspace.init.MiscInit;
import com.rae.creatingspace.init.PacketInit;
import com.rae.creatingspace.init.RecipeInit;
import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.graphics.MenuTypesInit;
import com.rae.creatingspace.init.graphics.ParticleTypeInit;
import com.rae.creatingspace.init.ingameobject.BlockEntityInit;
import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.init.ingameobject.EntityInit;
import com.rae.creatingspace.init.ingameobject.FluidInit;
import com.rae.creatingspace.init.ingameobject.ItemInit;
import com.rae.creatingspace.init.ingameobject.PaintingInit;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.init.ingameobject.SoundInit;
import com.rae.creatingspace.init.worldgen.CarverInit;
import com.rae.creatingspace.saved.UnlockedDesignManager;
import com.rae.creatingspace.server.contraption.CSContraptionType;
import com.rae.creatingspace.server.event.IgniteOnPlace;
import com.rae.creatingspace.utilities.data.MassOfBlockReader;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="creatingspace")
public class CreatingSpace {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "creatingspace";
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"creatingspace");
    public static final UnlockedDesignManager DESIGN_SAVED_DATA = new UnlockedDesignManager();

    public CreatingSpace() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modEventBus.addListener(event -> {
            event.dataPackRegistry(RocketAccessibleDimension.REGISTRY_KEY, RocketAccessibleDimension.CODEC, RocketAccessibleDimension.CODEC);
            event.dataPackRegistry(MiscInit.Keys.POWER_PACK_TYPE, PowerPackType.DIRECT_CODEC, PowerPackType.DIRECT_CODEC);
            event.dataPackRegistry(MiscInit.Keys.EXHAUST_PACK_TYPE, ExhaustPackType.DIRECT_CODEC, ExhaustPackType.DIRECT_CODEC);
            event.dataPackRegistry(PropellantTypeInit.Keys.PROPELLANT_TYPE, PropellantType.DIRECT_CODEC, PropellantType.DIRECT_CODEC);
            LOGGER.debug("added reload for CS registries");
        });
        REGISTRATE.registerEventListeners(modEventBus);
        TagsInit.init();
        SoundInit.register();
        ItemInit.register();
        BlockInit.register();
        BlockEntityInit.register();
        EntityInit.register();
        FluidInit.register();
        PropellantTypeInit.register(modEventBus);
        PaintingInit.register(modEventBus);
        RecipeInit.register(modEventBus);
        ParticleTypeInit.register(modEventBus);
        CarverInit.register(modEventBus);
        EntityDataSerializersInit.register(modEventBus);
        MiscInit.register(modEventBus);
        CreativeModeTabsInit.register(modEventBus);
        CSConfigs.registerConfigs(modLoadingContext);
        MenuTypesInit.register();
        PacketInit.registerPackets();
        IgniteOnPlace.register();
        CSContraptionType.prepare();
        modEventBus.addListener(CreatingSpace::init);
        modEventBus.addListener(EventPriority.LOWEST, CSDatagen::gatherData);
        forgeEventBus.addListener(CreatingSpace::onAddReloadListeners);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreatingSpaceClient.clientRegister(modEventBus));
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FluidInit.registerFluidInteractions();
            FluidInit.registerOpenEndedEffect();
        });
    }

    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(MassOfBlockReader.MASS_HOLDER);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE));
    }
}

