/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.gui;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.init.graphics.GuiTexturesInit;
import com.rae.creatingspace.utilities.CSDimensionUtil;
import com.simibubi.create.foundation.gui.widget.BoxWidget;
import com.simibubi.create.foundation.utility.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Orbit
extends BoxWidget {
    private Integer windowHeight = null;
    private Integer windowWidth = null;
    private double planetY;
    private double planetX;
    private final ResourceLocation dim;
    int radius;
    private float zoom;
    private Integer maxSatelliteDistance = 0;
    int bodyRadius = 5;
    private int xShift;
    private int yShift;
    ArrayList<Orbit> satellites = new ArrayList();

    public void setBodyRadius(int bodyRadius) {
        this.bodyRadius = bodyRadius;
    }

    public void setxShift(int xShift) {
        this.xShift = xShift;
    }

    public void setyShift(int yShift) {
        this.yShift = yShift;
    }

    public void setSatellites(List<Orbit> satellites) {
        this.satellites = new ArrayList<Orbit>(satellites);
    }

    public void addSatellite(Orbit satellite) {
        this.satellites.add(satellite);
        if (this.maxSatelliteDistance < satellite.radius) {
            this.maxSatelliteDistance = satellite.radius;
        }
    }

    public int getMaxSatelliteDistance() {
        return this.maxSatelliteDistance;
    }

    public Orbit(int centerX, int centerY, int radius, ResourceLocation dim) {
        super(centerX, centerY, radius * 2, radius * 2);
        this.radius = radius;
        this.dim = dim;
    }

    public Orbit(int centerX, int centerY, int radius, ResourceLocation dim, List<Orbit> satellites) {
        super(centerX, centerY, radius * 2, radius * 2);
        this.radius = radius;
        this.dim = dim;
        this.satellites = new ArrayList<Orbit>(satellites);
    }

    public void setWindow(int windowHeight, int windowWidth) {
        this.windowHeight = windowHeight;
        this.windowWidth = windowWidth;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return (double)(((float)this.radius / this.zoom - 5.0f) * ((float)this.radius / this.zoom - 5.0f)) < ((double)(this.m_252754_() + this.xShift) - mouseX) * ((double)(this.m_252754_() + this.xShift) - mouseX) + ((double)(this.m_252907_() + this.yShift) - mouseY) * ((double)(this.m_252907_() + this.yShift) - mouseY) && ((double)(this.m_252754_() + this.xShift) - mouseX) * ((double)(this.m_252754_() + this.xShift) - mouseX) + ((double)(this.m_252907_() + this.yShift) - mouseY) * ((double)(this.m_252907_() + this.yShift) - mouseY) < (double)(((float)this.radius / this.zoom + 5.0f) * ((float)this.radius / this.zoom + 5.0f));
    }

    public void m_88315_(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            this.f_93622_ = this.m_5953_(mouseX, mouseY);
            this.beforeRender(ms, mouseX, mouseY, partialTicks);
            this.renderButton(ms, mouseX, mouseY, partialTicks);
            this.afterRender(ms, mouseX, mouseY, partialTicks);
            this.wasHovered = this.m_198029_();
        }
        float theta = this.getTheta(partialTicks);
        this.planetX = CSDimensionUtil.isOrbit(this.dim) ? (double)this.m_252754_() : (double)this.m_252754_() + (double)((float)this.radius / this.zoom) * Math.sin(theta);
        this.planetY = CSDimensionUtil.isOrbit(this.dim) ? (double)this.m_252907_() : (double)this.m_252907_() + (double)((float)this.radius / this.zoom) * Math.cos(theta);
        for (Orbit orbit : this.satellites) {
            orbit.m_252865_((int)this.planetX);
            orbit.m_253211_((int)this.planetY);
        }
    }

    public void renderButton(@NotNull GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        if (this.isInsideWindow(this.m_252754_() + this.xShift, this.m_252907_() + this.yShift)) {
            this.drawCircle(ms, this.m_252754_() + this.xShift, this.m_252907_() + this.yShift, (int)((float)this.radius / this.zoom));
        }
        if (this.isInsideWindow((int)((double)this.xShift + this.getPlanetX()), (int)((double)this.yShift + this.getPlanetY()))) {
            this.drawBody(ms, (int)((double)this.xShift + this.getPlanetX()), (int)((double)this.yShift + this.getPlanetY()));
        }
    }

    private boolean isInsideWindow(int x, int y) {
        if (this.windowWidth == null || this.windowHeight == null) {
            return true;
        }
        boolean flag1 = (float)(-this.radius) / this.zoom <= (float)x && (float)x <= (float)this.windowWidth.intValue() + (float)this.radius / this.zoom && 0 <= y && y <= this.windowHeight;
        boolean flag2 = (float)(-this.radius) / this.zoom <= (float)y && (float)y <= (float)this.windowHeight.intValue() + (float)this.radius / this.zoom && 0 <= x && x <= this.windowWidth;
        boolean flag3 = (float)(x * x + y * y) <= (float)this.radius / this.zoom * ((float)this.radius / this.zoom) || (float)((x - this.windowWidth) * (x - this.windowWidth) + y * y) <= (float)this.radius / this.zoom * ((float)this.radius / this.zoom) || (float)(x * x + (y - this.windowHeight) * (y - this.windowHeight)) <= (float)this.radius / this.zoom * ((float)this.radius / this.zoom) || (float)((x - this.windowWidth) * (x - this.windowWidth) + (y - this.windowHeight) * (y - this.windowHeight)) <= (float)this.radius / this.zoom * ((float)this.radius / this.zoom);
        return flag1 || flag2 || flag3;
    }

    public double getPlanetY() {
        return this.planetY;
    }

    public double getPlanetX() {
        return this.planetX;
    }

    private float getTheta(float partialTicks) {
        float time = (float)Objects.requireNonNull(Minecraft.m_91087_().m_91288_()).f_19797_ + partialTicks;
        float speed = 0.01f;
        return this.radius > 0 ? (float)((double)(time * 2.0f) * Math.PI / (double)this.radius) * speed : 1.0f;
    }

    private void drawBody(GuiGraphics ms, int centerX, int centerY) {
        if (!CSDimensionUtil.isOrbit(this.dim)) {
            GuiTexturesInit.render(CreatingSpace.resource("textures/gui/destination/" + this.dim.m_135815_() + ".png"), ms, centerX - this.bodyRadius, centerY - this.bodyRadius, 0, 0, this.bodyRadius * 2 + 1, this.bodyRadius * 2 + 1, this.bodyRadius * 2 + 1, this.bodyRadius * 2 + 1, Color.WHITE);
        }
    }

    protected boolean m_93680_(double pMouseX, double pMouseY) {
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        return this.m_5953_(pMouseX, pMouseY);
    }

    private void drawCircle(GuiGraphics graphics, int x, int y, int radius) {
        if (radius > 8) {
            int color = this.gradientColor1.getRGB();
            int startX = 0;
            int startY = radius;
            int stopY = 0;
            int length = 0;
            if (radius > this.windowWidth) {
                if (x > y) {
                    if (x < 0) {
                        startX = Math.max(-x, 0);
                    } else if (x > this.windowWidth) {
                        startX = Math.max(x - this.windowWidth, this.windowWidth);
                    }
                    stopY = (int)Math.sqrt(Math.min(radius * radius - x * x, radius * radius - (x - this.windowWidth) * (x - this.windowWidth)));
                    startY = (int)Math.sqrt(Math.max(radius * radius - x * x, radius * radius - (x - this.windowWidth) * (x - this.windowWidth)));
                } else {
                    if (y < 0) {
                        startX = Math.max(-y, 0);
                    } else if (y > this.windowHeight) {
                        startX = Math.max(y - this.windowHeight, this.windowHeight);
                    }
                    stopY = (int)Math.sqrt(Math.min(radius * radius - y * y, radius * radius - (y - this.windowHeight) * (y - this.windowHeight)));
                    startY = (int)Math.sqrt(Math.max(radius * radius - y * y, radius * radius - (y - this.windowHeight) * (y - this.windowHeight)));
                }
            }
            int d = 1 - radius;
            while (startX <= startY && startY >= stopY) {
                if (d < 0) {
                    d += 2 * (startX + length) + 3;
                } else {
                    this.drawSymmetricLines(graphics, x, y, startX, startY, length, color);
                    d += 2 * (startX + length - startY) + 5;
                    --startY;
                    startX += length;
                    length = 0;
                }
                ++length;
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.m_93692_(true);
    }

    private void drawSymmetricLines(GuiGraphics graphics, int centerX, int centerY, int startX, int startY, int length, int color) {
        graphics.m_280656_(centerX + startX, centerX + startX + length, centerY + startY, color);
        graphics.m_280656_(centerX - startX - length, centerX - startX, centerY + startY, color);
        graphics.m_280656_(centerX + startX, centerX + startX + length, centerY - startY, color);
        graphics.m_280656_(centerX - startX - length, centerX - startX, centerY - startY, color);
        graphics.m_280315_(centerX + startY, centerY + startX - 1, centerY + startX + length + 1, color);
        graphics.m_280315_(centerX + startY, centerY - startX - length - 1, centerY - startX + 1, color);
        graphics.m_280315_(centerX - startY, centerY + startX - 1, centerY + startX + length + 1, color);
        graphics.m_280315_(centerX - startY, centerY - startX - length - 1, centerY - startX + 1, color);
    }

    public ResourceLocation getDim() {
        return this.dim;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void shiftX(int amount) {
        this.xShift += amount;
    }

    public void shiftY(int amount) {
        this.yShift += amount;
    }
}

