/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.utility.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GeometryRendering {
    public static void renderCylinder(VertexConsumer vertexBuilder, PoseStack matrixStack, Vec3 offset, Color color, int packedLight, float baseRadius, float topRadius, float height, int segments, boolean exterior) {
        float angleIncrement = (float)(Math.PI * 2 / (double)segments);
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)i * angleIncrement;
            float angle2 = (float)((i + 1) % segments) * angleIncrement;
            ArrayList<Vec3> faceVertexes = new ArrayList<Vec3>();
            faceVertexes.add(new Vec3((double)(topRadius * Mth.m_14089_((float)angle1)), (double)height, (double)(topRadius * Mth.m_14031_((float)angle1))).m_82549_(offset));
            faceVertexes.add(new Vec3((double)(topRadius * Mth.m_14089_((float)angle2)), (double)height, (double)(topRadius * Mth.m_14031_((float)angle2))).m_82549_(offset));
            faceVertexes.add(new Vec3((double)(baseRadius * Mth.m_14089_((float)angle2)), 0.0, (double)(baseRadius * Mth.m_14031_((float)angle2))).m_82549_(offset));
            faceVertexes.add(new Vec3((double)(baseRadius * Mth.m_14089_((float)angle1)), 0.0, (double)(baseRadius * Mth.m_14031_((float)angle1))).m_82549_(offset));
            if (!exterior) {
                Collections.reverse(faceVertexes);
            }
            PoseStack.Pose entry = matrixStack.m_85850_();
            GeometryRendering.renderPoly(faceVertexes, vertexBuilder, entry, packedLight, color);
        }
    }

    public static void renderCube(VertexConsumer vertexBuilder, PoseStack matrixStack, Vec3 offset, int packedLight, float size, Color color) {
        float halfSize = size / 2.0f;
        Vec3 v0 = new Vec3((double)(-halfSize), (double)(-halfSize), (double)(-halfSize)).m_82549_(offset);
        Vec3 v1 = new Vec3((double)halfSize, (double)(-halfSize), (double)(-halfSize)).m_82549_(offset);
        Vec3 v2 = new Vec3((double)halfSize, (double)halfSize, (double)(-halfSize)).m_82549_(offset);
        Vec3 v3 = new Vec3((double)(-halfSize), (double)halfSize, (double)(-halfSize)).m_82549_(offset);
        Vec3 v4 = new Vec3((double)(-halfSize), (double)(-halfSize), (double)halfSize).m_82549_(offset);
        Vec3 v5 = new Vec3((double)halfSize, (double)(-halfSize), (double)halfSize).m_82549_(offset);
        Vec3 v6 = new Vec3((double)halfSize, (double)halfSize, (double)halfSize).m_82549_(offset);
        Vec3 v7 = new Vec3((double)(-halfSize), (double)halfSize, (double)halfSize).m_82549_(offset);
        List<Vec3> face1 = List.of(v0, v3, v2, v1);
        List<Vec3> face2 = List.of(v5, v6, v7, v4);
        List<Vec3> face3 = List.of(v1, v2, v6, v5);
        List<Vec3> face4 = List.of(v4, v7, v3, v0);
        List<Vec3> face5 = List.of(v3, v7, v6, v2);
        List<Vec3> face6 = List.of(v0, v1, v5, v4);
        PoseStack.Pose entry = matrixStack.m_85850_();
        GeometryRendering.renderPoly(face1, vertexBuilder, entry, packedLight, color);
        GeometryRendering.renderPoly(face2, vertexBuilder, entry, packedLight, color);
        GeometryRendering.renderPoly(face3, vertexBuilder, entry, packedLight, color);
        GeometryRendering.renderPoly(face4, vertexBuilder, entry, packedLight, color);
        GeometryRendering.renderPoly(face5, vertexBuilder, entry, packedLight, color);
        GeometryRendering.renderPoly(face6, vertexBuilder, entry, packedLight, color);
    }

    public static void renderPoly(List<Vec3> pos, VertexConsumer vertexBuilder, PoseStack.Pose entry, int packedLight, Color color) {
        Vec3 centerPos = new Vec3(0.0, 0.0, 0.0);
        for (Vec3 coord : pos) {
            centerPos = centerPos.m_82549_(coord);
        }
        centerPos = centerPos.m_82542_(1.0 / (double)pos.size(), 1.0 / (double)pos.size(), 1.0 / (double)pos.size());
        for (Vec3 coord : pos) {
            Vec3 normal = coord.m_82546_(centerPos);
            vertexBuilder.m_252986_(entry.m_252922_(), (float)coord.f_82479_, (float)coord.f_82480_, (float)coord.f_82481_).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(entry.m_252943_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        }
    }

    public static void renderPolyTex(List<Vec3> pos, List<Vec2> uvVector, VertexConsumer vertexBuilder, PoseStack.Pose entry, int packedLight) {
        Vec3 centerPos = new Vec3(0.0, 0.0, 0.0);
        for (Vec3 coord : pos) {
            centerPos = centerPos.m_82549_(coord);
        }
        centerPos = centerPos.m_82542_(1.0 / (double)pos.size(), 1.0 / (double)pos.size(), 1.0 / (double)pos.size());
        for (int i = 0; i < pos.size(); ++i) {
            Vec3 coord;
            coord = pos.get(i);
            Vec2 uv = uvVector.get(i);
            Vec3 normal = coord.m_82546_(centerPos);
            vertexBuilder.m_252986_(entry.m_252922_(), (float)coord.f_82479_, (float)coord.f_82480_, (float)coord.f_82481_).m_6122_(255, 255, 255, 255).m_7421_(uv.f_82470_, uv.f_82471_).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(entry.m_252943_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
        }
    }
}

