/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.rae.creatingspace.api.rendering.GeometryRendering;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Color;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PlanetsRendering {
    public static void renderPlanet(ResourceLocation texture, MultiBufferSource buffer, PoseStack matrixStack, int packedLight, float size, float distance, float theta, float phi, float alpha) {
        VertexConsumer planetBuffer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(phi));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(theta));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(alpha));
        matrixStack.m_252880_(distance, 0.0f, 0.0f);
        float halfSize = size / 2.0f;
        Vec3 v0 = new Vec3((double)(-halfSize), (double)(-halfSize), (double)(-halfSize));
        Vec3 v1 = new Vec3((double)halfSize, (double)(-halfSize), (double)(-halfSize));
        Vec3 v2 = new Vec3((double)halfSize, (double)halfSize, (double)(-halfSize));
        Vec3 v3 = new Vec3((double)(-halfSize), (double)halfSize, (double)(-halfSize));
        Vec3 v4 = new Vec3((double)(-halfSize), (double)(-halfSize), (double)halfSize);
        Vec3 v5 = new Vec3((double)halfSize, (double)(-halfSize), (double)halfSize);
        Vec3 v6 = new Vec3((double)halfSize, (double)halfSize, (double)halfSize);
        Vec3 v7 = new Vec3((double)(-halfSize), (double)halfSize, (double)halfSize);
        List<Vec3> face1 = List.of(v0, v3, v2, v1);
        List<Vec3> face2 = List.of(v5, v6, v7, v4);
        List<Vec3> face3 = List.of(v1, v2, v6, v5);
        List<Vec3> face4 = List.of(v4, v7, v3, v0);
        List<Vec3> face5 = List.of(v3, v7, v6, v2);
        List<Vec3> face6 = List.of(v0, v1, v5, v4);
        List<Vec2> uvs = List.of(new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f));
        PoseStack.Pose entry = matrixStack.m_85850_();
        GeometryRendering.renderPolyTex(face1, uvs, planetBuffer, entry, packedLight);
        GeometryRendering.renderPolyTex(face2, uvs, planetBuffer, entry, packedLight);
        GeometryRendering.renderPolyTex(face3, uvs, planetBuffer, entry, packedLight);
        GeometryRendering.renderPolyTex(face4, uvs, planetBuffer, entry, packedLight);
        GeometryRendering.renderPolyTex(face5, uvs, planetBuffer, entry, packedLight);
        GeometryRendering.renderPolyTex(face6, uvs, planetBuffer, entry, packedLight);
    }

    public static void renderPlanet(ResourceLocation texture, PoseStack matrixStack, int packedLight, float size, float distance, float theta, float phi, float alpha) {
        PlanetsRendering.renderPlanet(texture, (MultiBufferSource)SuperRenderTypeBuffer.getInstance(), matrixStack, packedLight, size, distance, theta, phi, alpha);
    }

    public static void renderAtmosphere(MultiBufferSource buffer, PoseStack matrixStack, Color color, int packedLight, float size, float distance, float theta, float phi, float alpha) {
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderTypes.getGlowingTranslucent((ResourceLocation)AllSpecialTextures.BLANK.getLocation()));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(phi));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(theta));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(alpha));
        matrixStack.m_252880_(distance, 0.0f, 0.0f);
        GeometryRendering.renderCube(vertexBuilder, matrixStack, Vec3.f_82478_, packedLight, size + 10.0f, color);
    }
}

