/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.condition;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.api.squedule.condition.LazyTickedScheduleCondition;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class CargoThresholdCondition
extends LazyTickedScheduleCondition {
    public CargoThresholdCondition() {
        super(20);
        this.data.m_128359_("Threshold", "10");
    }

    @Override
    public boolean lazyTickCompletion(Level level, RocketContraptionEntity rocket, CompoundTag context) {
        int lastChecked = context.m_128441_("LastChecked") ? context.m_128451_("LastChecked") : -1;
        return this.test(level, rocket, context);
    }

    protected void requestStatusToUpdate(int amount, CompoundTag context) {
        context.m_128405_("CurrentDisplay", amount);
        super.requestStatusToUpdate(context);
    }

    protected int getLastDisplaySnapshot(CompoundTag context) {
        if (!context.m_128441_("CurrentDisplay")) {
            return -1;
        }
        return context.m_128451_("CurrentDisplay");
    }

    protected abstract boolean test(Level var1, RocketContraptionEntity var2, CompoundTag var3);

    protected abstract Component getUnit();

    protected abstract ItemStack getIcon();

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)this.getIcon(), (Object)Components.literal((String)(this.getOperator().formatted + " " + this.getThreshold())).m_7220_(this.getUnit()));
    }

    public int slotsTargeted() {
        return 1;
    }

    public Ops getOperator() {
        return (Ops)((Object)this.enumData("Operator", Ops.class));
    }

    public int getThreshold() {
        try {
            return Integer.valueOf(this.textData("Threshold"));
        }
        catch (NumberFormatException e) {
            this.data.m_128359_("Threshold", "0");
            return 0;
        }
    }

    public int getMeasure() {
        return this.intData("Measure");
    }

    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect((String)"schedule.condition.threshold.place_item", (Object[])new Object[0]), (Object)Lang.translateDirect((String)"schedule.condition.threshold.place_item_2", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY), (Object)Lang.translateDirect((String)"schedule.condition.threshold.place_item_3", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(0, 24, (i, l) -> i.forOptions(Ops.translatedOptions()).titled(Lang.translateDirect((String)"schedule.condition.threshold.train_holds", (Object[])new Object[0])).format(state -> Components.literal((String)(" " + Ops.values()[state.intValue()].formatted))), "Operator");
        builder.addIntegerTextInput(29, 41, (e, t) -> {}, "Threshold");
    }

    public static enum Ops {
        GREATER(">"),
        LESS("<"),
        EQUAL("=");

        public String formatted;

        private Ops(String formatted) {
            this.formatted = formatted;
        }

        public boolean test(int current, int target) {
            return switch (this) {
                case GREATER -> {
                    if (current > target) {
                        yield true;
                    }
                    yield false;
                }
                case EQUAL -> {
                    if (current == target) {
                        yield true;
                    }
                    yield false;
                }
                case LESS -> {
                    if (current < target) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalArgumentException("Unexpected value: " + this);
            };
        }

        public static List<? extends Component> translatedOptions() {
            return Arrays.stream(Ops.values()).map(op -> Lang.translateDirect((String)("schedule.condition.threshold." + Lang.asId((String)op.name())), (Object[])new Object[0])).toList();
        }
    }
}

