/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.condition;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.api.squedule.condition.CargoThresholdCondition;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidThresholdCondition
extends CargoThresholdCondition {
    private FilterItemStack compareStack = FilterItemStack.empty();

    @Override
    protected Component getUnit() {
        return Components.literal((String)"b");
    }

    @Override
    protected ItemStack getIcon() {
        return this.compareStack.item();
    }

    @Override
    protected boolean test(Level level, RocketContraptionEntity rocket, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        int foundFluid = 0;
        IFluidHandler fluids = rocket.getContraption().getSharedFluidTanks();
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidInTank = fluids.getFluidInTank(i);
            if (!this.compareStack.test(level, fluidInTank)) continue;
            foundFluid += fluidInTank.getAmount();
        }
        this.requestStatusToUpdate(foundFluid / 1000, context);
        return operator.test(foundFluid, target * 1000);
    }

    protected void writeAdditional(CompoundTag tag) {
        super.writeAdditional(tag);
        tag.m_128365_("Bucket", (Tag)this.compareStack.serializeNBT());
    }

    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (tag.m_128441_("Bucket")) {
            this.compareStack = FilterItemStack.of((CompoundTag)tag.m_128469_("Bucket"));
        }
    }

    @Override
    public boolean tickCompletion(Level level, RocketContraptionEntity train, CompoundTag context) {
        return super.tickCompletion(level, train, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    private FluidStack loadFluid() {
        return this.compareStack.fluid((Level)Minecraft.m_91087_().f_91073_);
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect((String)"schedule.condition.threshold.train_holds", (Object[])new Object[]{Lang.translateDirect((String)("schedule.condition.threshold." + Lang.asId((String)this.getOperator().name())), (Object[])new Object[0])}), (Object)Lang.translateDirect((String)"schedule.condition.threshold.x_units_of_item", (Object[])new Object[]{this.getThreshold(), Lang.translateDirect((String)"schedule.condition.threshold.buckets", (Object[])new Object[0]), this.compareStack.isEmpty() ? Lang.translateDirect((String)"schedule.condition.threshold.anything", (Object[])new Object[0]) : (this.compareStack.isFilterItem() ? Lang.translateDirect((String)"schedule.condition.threshold.matching_content", (Object[])new Object[0]) : this.loadFluid().getDisplayName())}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public void setItem(int slot, ItemStack stack) {
        this.compareStack = FilterItemStack.of((ItemStack)stack);
    }

    public ItemStack getItem(int slot) {
        return this.compareStack.item();
    }

    public ResourceLocation getId() {
        return Create.asResource((String)"fluid_threshold");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List)ImmutableList.of((Object)Lang.translateDirect((String)"schedule.condition.threshold.buckets", (Object[])new Object[0]))).titled(null), "Measure");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, RocketContraptionEntity rocket, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect((String)"schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), Lang.translateDirect((String)"schedule.condition.threshold.buckets", (Object[])new Object[0])});
    }
}

