/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.api.squedule.condition;

import com.google.common.collect.ImmutableList;
import com.rae.creatingspace.api.squedule.condition.ScheduleWaitCondition;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneLinkCondition
extends ScheduleWaitCondition {
    public Couple<RedstoneLinkNetworkHandler.Frequency> freq = Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);

    public int slotsTargeted() {
        return 2;
    }

    public Pair<ItemStack, Component> getSummary() {
        return Pair.of((Object)AllBlocks.REDSTONE_LINK.asStack(), (Object)(this.lowActivation() ? Lang.translateDirect((String)"schedule.condition.redstone_link_off", (Object[])new Object[0]) : Lang.translateDirect((String)"schedule.condition.redstone_link_on", (Object[])new Object[0])));
    }

    public List<Component> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)Lang.translateDirect((String)(slot == 0 ? "logistics.firstFrequency" : "logistics.secondFrequency"), (Object[])new Object[0]).m_130940_(ChatFormatting.RED));
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect((String)("schedule.condition.redstone_link.frequency_" + (this.lowActivation() ? "unpowered" : "powered")), (Object[])new Object[0]), (Object)Components.literal((String)" #1 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((RedstoneLinkNetworkHandler.Frequency)this.freq.getFirst()).getStack().m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)), (Object)Components.literal((String)" #2 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)((RedstoneLinkNetworkHandler.Frequency)this.freq.getSecond()).getStack().m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)));
    }

    @Override
    public boolean tickCompletion(Level level, RocketContraptionEntity train, CompoundTag context) {
        int lastChecked = context.m_128441_("LastChecked") ? context.m_128451_("LastChecked") : -1;
        int status = Create.REDSTONE_LINK_NETWORK_HANDLER.globalPowerVersion.get();
        if (status == lastChecked) {
            return false;
        }
        context.m_128405_("LastChecked", status);
        return Create.REDSTONE_LINK_NETWORK_HANDLER.hasAnyLoadedPower(this.freq) != this.lowActivation();
    }

    public void setItem(int slot, ItemStack stack) {
        this.freq.set(slot == 0, (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack));
        super.setItem(slot, stack);
    }

    public ItemStack getItem(int slot) {
        return ((RedstoneLinkNetworkHandler.Frequency)this.freq.get(slot == 0)).getStack();
    }

    public ResourceLocation getId() {
        return Create.asResource((String)"redstone_link");
    }

    protected void writeAdditional(CompoundTag tag) {
        tag.m_128365_("Frequency", (Tag)this.freq.serializeEach(f -> f.getStack().serializeNBT()));
    }

    public boolean lowActivation() {
        return this.intData("Inverted") == 1;
    }

    protected void readAdditional(CompoundTag tag) {
        if (tag.m_128441_("Frequency")) {
            this.freq = Couple.deserializeEach((ListTag)tag.m_128437_("Frequency", 10), c -> RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.m_41712_((CompoundTag)c)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(20, 101, (i, l) -> i.forOptions(Lang.translatedOptions((String)"schedule.condition.redstone_link", (String[])new String[]{"powered", "unpowered"})).titled(Lang.translateDirect((String)"schedule.condition.redstone_link.frequency_state", (Object[])new Object[0])), "Inverted");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, RocketContraptionEntity train, CompoundTag tag) {
        return Lang.translateDirect((String)"schedule.condition.redstone_link.status", (Object[])new Object[0]);
    }
}

