/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.client.effects;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.rae.creatingspace.api.rendering.PlanetsRendering;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class CustomDimensionEffects
extends DimensionSpecialEffects {
    private static final ResourceLocation SPACE_SKY_LOCATION = new ResourceLocation("creatingspace", "textures/environment/space_sky.png");
    private static final ResourceLocation EARTH_LOCATION = new ResourceLocation("creatingspace", "textures/environment/earth.png");
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("creatingspace", "textures/environment/moon.png");
    private static final ResourceLocation MARS_LOCATION = new ResourceLocation("creatingspace", "textures/environment/mars.png");
    private static final ResourceLocation SATURN_LOCATION = new ResourceLocation("creatingspace", "textures/environment/saturn.png");
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation MOON_PHASES_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");

    public CustomDimensionEffects(float cloudLevel, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(cloudLevel, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
    }

    public Vec3 m_5927_(Vec3 vec, float brightness) {
        return vec;
    }

    public boolean m_5781_(int p_108874_, int p_108875_) {
        return false;
    }

    private static BufferBuilder renderSpaceSky(PoseStack poseStack) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SPACE_SKY_LOCATION);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            poseStack.m_85836_();
            if (i == 1) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            if (i == 2) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            if (i == 3) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            }
            if (i == 4) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            if (i == 5) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            int l = i % 3;
            int i1 = i / 4 % 2;
            float col_begin = (float)l / 3.0f;
            float l_begin = (float)i1 / 2.0f;
            float col_end = (float)(l + 1) / 3.0f;
            float l_end = (float)(i1 + 1) / 2.0f;
            float size = 100.0f;
            float distance = 100.0f;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_252986_(matrix4f, -size, -distance, -size).m_7421_(col_end, l_end).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -size, -distance, size).m_7421_(col_begin, l_end).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, size, -distance, size).m_7421_(col_begin, l_begin).m_6122_(255, 255, 255, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, size, -distance, -size).m_7421_(col_end, l_begin).m_6122_(255, 255, 255, 255).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
        return bufferbuilder;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GenericCelestialOrbitEffect
    extends CustomDimensionEffects {
        private boolean renderSun = true;

        public GenericCelestialOrbitEffect() {
            super(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, false);
        }

        public void setRenderSun(boolean renderSun) {
            this.renderSun = renderSun;
        }

        public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
            return true;
        }

        public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
            return true;
        }

        public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
            return true;
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            BufferBuilder bufferbuilder = CustomDimensionEffects.renderSpaceSky(poseStack);
            this.renderAdditionalBody(level, ticks, partialTick, poseStack, bufferbuilder, camera, projectionMatrix);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            return true;
        }

        protected void renderAdditionalBody(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, BufferBuilder bufferbuilder, Camera camera, Matrix4f projectionMatrix) {
            if (this.renderSun) {
                this.renderAstralBody(poseStack, bufferbuilder, SUN_LOCATION, true, camera.m_90592_().m_9236_().m_46942_(partialTick) * 360.0f, 30.0f, 100.0f);
            }
        }

        protected void renderAstralBody(PoseStack poseStack, BufferBuilder bufferbuilder, ResourceLocation bodyTexture, boolean old, float rotationAngle, float bodySize, float bodyDistance) {
            this.renderAstralBody(poseStack, bufferbuilder, bodyTexture, rotationAngle, bodySize, bodyDistance, 0.0f, 1.0f, 1.0f, 0.0f, old);
        }

        protected void renderAstralBody(PoseStack poseStack, BufferBuilder bufferbuilder, ResourceLocation bodyTexture, float rotationAngle, float bodySize, float bodyDistance, float f15, float f13, float f16, float f14, boolean old) {
            poseStack.m_85836_();
            RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f));
            if (old) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(rotationAngle));
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)bodyTexture);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f, -bodySize, bodyDistance, -bodySize).m_7421_(f15, f14).m_5752_();
                bufferbuilder.m_252986_(matrix4f, bodySize, bodyDistance, -bodySize).m_7421_(f13, f14).m_5752_();
                bufferbuilder.m_252986_(matrix4f, bodySize, bodyDistance, bodySize).m_7421_(f13, f16).m_5752_();
                bufferbuilder.m_252986_(matrix4f, -bodySize, bodyDistance, bodySize).m_7421_(f15, f16).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            } else {
                PlanetsRendering.renderPlanet(bodyTexture, poseStack, 0xF00000, bodySize, bodyDistance, 0.0f, 0.0f, rotationAngle);
                poseStack.m_85849_();
                poseStack.m_85836_();
                PlanetsRendering.renderAtmosphere((MultiBufferSource)SuperRenderTypeBuffer.getInstance(), poseStack, new Color(0.1f, 0.2f, 0.6f, 0.3f), 0xF00000, bodySize, bodyDistance, 0.0f, 0.0f, rotationAngle);
            }
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EarthOrbitEffects
    extends GenericCelestialOrbitEffect {
        @Override
        protected void renderAdditionalBody(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, BufferBuilder bufferbuilder, Camera camera, Matrix4f projectionMatrix) {
            super.renderAdditionalBody(level, ticks, partialTick, poseStack, bufferbuilder, camera, projectionMatrix);
            int k = camera.m_90592_().m_9236_().m_46941_();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f13 = (float)l / 4.0f;
            float f14 = (float)i1 / 2.0f;
            float f15 = (float)(l + 1) / 4.0f;
            float f16 = (float)(i1 + 1) / 2.0f;
            this.renderAstralBody(poseStack, bufferbuilder, MOON_PHASES_LOCATION, camera.m_90592_().m_9236_().m_46942_(partialTick) * 360.0f + 180.0f, 20.0f, 100.0f, f15, f13, f16, f14, true);
            BlockPos pos = camera.m_90592_().m_20097_();
            int height = pos.m_123342_();
            int minHeight = -64;
            int maxHeight = 384;
            this.renderAstralBody(poseStack, bufferbuilder, EARTH_LOCATION, true, 180.0f, 150.0f, 60.0f + (float)(height - minHeight) / (float)(maxHeight - minHeight) * 40.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MarsOrbitEffects
    extends GenericCelestialOrbitEffect {
        @Override
        protected void renderAdditionalBody(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, BufferBuilder bufferbuilder, Camera camera, Matrix4f projectionMatrix) {
            super.renderAdditionalBody(level, ticks, partialTick, poseStack, bufferbuilder, camera, projectionMatrix);
            BlockPos pos = camera.m_90592_().m_20097_();
            int height = pos.m_123342_();
            int minHeight = -64;
            int maxHeight = 384;
            this.renderAstralBody(poseStack, bufferbuilder, MARS_LOCATION, true, 180.0f, 150.0f, (float)(height - minHeight) / (float)(maxHeight - minHeight) * 40.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MoonOrbitEffect
    extends GenericCelestialOrbitEffect {
        @Override
        protected void renderAdditionalBody(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, BufferBuilder bufferbuilder, Camera camera, Matrix4f projectionMatrix) {
            super.renderAdditionalBody(level, ticks, partialTick, poseStack, bufferbuilder, camera, projectionMatrix);
            this.renderAstralBody(poseStack, bufferbuilder, EARTH_LOCATION, true, camera.m_90592_().m_9236_().m_46942_(partialTick) * 360.0f + 180.0f, 18.0f, 100.0f);
            BlockPos pos = camera.m_90592_().m_20097_();
            int height = pos.m_123342_();
            int minHeight = -64;
            int maxHeight = 384;
            this.renderAstralBody(poseStack, bufferbuilder, MOON_LOCATION, true, 180.0f, 150.0f, 60.0f + (float)(height - minHeight) / (float)(maxHeight - minHeight) * 40.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MarsEffect
    extends GenericCelestialOrbitEffect {
        @Override
        protected void renderAdditionalBody(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, BufferBuilder bufferbuilder, Camera camera, Matrix4f projectionMatrix) {
            super.renderAdditionalBody(level, ticks, partialTick, poseStack, bufferbuilder, camera, projectionMatrix);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MoonEffect
    extends GenericCelestialOrbitEffect {
        @Override
        protected void renderAdditionalBody(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, BufferBuilder bufferbuilder, Camera camera, Matrix4f projectionMatrix) {
            super.renderAdditionalBody(level, ticks, partialTick, poseStack, bufferbuilder, camera, projectionMatrix);
            this.renderAstralBody(poseStack, bufferbuilder, EARTH_LOCATION, true, camera.m_90592_().m_9236_().m_46942_(partialTick) * 360.0f + 180.0f, 20.0f, 100.0f);
        }
    }
}

