/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.client.event;

import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.client.gui.RemainingO2Overlay;
import com.rae.creatingspace.client.renderer.CopperOxygenBacktankFirstPersonRenderer;
import com.rae.creatingspace.client.renderer.NetheriteOxygenBacktankFirstPersonRenderer;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.server.armor.OxygenBacktankArmorLayer;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.rae.creatingspace.server.items.EngineFabricationBlueprint;
import com.rae.creatingspace.server.items.engine.EngineItem;
import com.rae.creatingspace.server.items.engine.RocketEngineItem;
import com.simibubi.create.content.trains.CameraDistanceModifier;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CSClientEvent {
    protected static boolean isGameActive() {
        return Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!CSClientEvent.isGameActive()) {
            return;
        }
        CopperOxygenBacktankFirstPersonRenderer.clientTick();
        NetheriteOxygenBacktankFirstPersonRenderer.clientTick();
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entity;
        if (event.getEntityMounting() == Minecraft.m_91087_().f_91074_ && event.isMounting() && (entity = event.getEntityBeingMounted()) instanceof RocketContraptionEntity) {
            RocketContraptionEntity rocketContraption = (RocketContraptionEntity)entity;
            CameraDistanceModifier.zoomOut((float)((float)(rocketContraption.m_20191_().m_82309_() * (Double)CSConfigs.CLIENT.zoomOut.get())));
        }
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        List components = event.getToolTip();
        if (!(itemStack.m_41720_() instanceof EngineFabricationBlueprint) && !(itemStack.m_41720_() instanceof EngineItem)) {
            CompoundTag engineInfo;
            CompoundTag recipeData = itemStack.m_41737_("engineRecipeData");
            if (recipeData != null) {
                int size = recipeData.m_128451_("size");
                int materialLevel = recipeData.m_128451_("materialLevel");
                components.add(Component.m_237113_((String)("size : " + size)));
                components.add(Component.m_237113_((String)("materialLevel : " + materialLevel)));
                try {
                    ResourceLocation exhaustPackType = (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)recipeData.m_128423_("exhaustPackType")).get().orThrow();
                    ResourceLocation powerPackType = (ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)recipeData.m_128423_("powerPackType")).get().orThrow();
                    components.add(Component.m_237115_((String)exhaustPackType.m_214296_("exhaust_pack_type")));
                    components.add(Component.m_237115_((String)powerPackType.m_214296_("power_pack_type")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((engineInfo = itemStack.m_41737_("blockEntity")) != null) {
                components.add(Component.m_237113_((String)"for engine :"));
                PropellantType propellantType = (PropellantType)PropellantTypeInit.getSyncedPropellantRegistry().m_6612_(ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)engineInfo.m_128423_("propellantType")).resultOrPartial(s -> {}).orElse(PropellantTypeInit.METHALOX.getId())).orElseThrow();
                RocketEngineItem.appendEngineDependentText(components, propellantType, (int)((float)propellantType.getMaxISP().intValue() * engineInfo.m_128457_("efficiency")), engineInfo.m_128451_("mass"), engineInfo.m_128451_("thrust"));
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            OxygenBacktankArmorLayer.registerOnAll(dispatcher);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAbove(VanillaGuiOverlay.HELMET.id(), "remaining_oxygen", (IGuiOverlay)RemainingO2Overlay.INSTANCE);
        }
    }
}

