/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.client.gui.screen;

import com.rae.creatingspace.api.planets.RocketAccessibleDimension;
import com.rae.creatingspace.client.gui.screen.elements.DimSelectBoxWidget;
import com.rae.creatingspace.client.gui.screen.elements.LabeledBoxWidget;
import com.rae.creatingspace.init.PacketInit;
import com.rae.creatingspace.init.graphics.GuiTexturesInit;
import com.rae.creatingspace.server.blockentities.RocketControlsBlockEntity;
import com.rae.creatingspace.utilities.CSDimensionUtil;
import com.rae.creatingspace.utilities.CSUtil;
import com.rae.creatingspace.utilities.packet.RocketAssemblePacket;
import com.rae.creatingspace.utilities.packet.RocketControlsSettingsPacket;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class DestinationScreen
extends AbstractSimiScreen {
    private boolean destinationChanged;
    private Button launchButton;
    private final HashMap<ResourceLocation, RocketAccessibleDimension.AccessibilityParameter> mapOfAccessibleDimensionAndV;
    HashMap<String, BlockPos> initialPosMap;
    private final RocketControlsBlockEntity blockEntity;
    private final GuiTexturesInit background;
    private final ResourceLocation currentDimension;
    private ResourceLocation destination;
    private final Vector<DimSelectBoxWidget> buttonVector;
    private LabeledBoxWidget destinationCost;
    private EditBox Xinput;
    private EditBox Zinput;
    Couple<Color> red = Theme.p((Theme.Key)Theme.Key.BUTTON_FAIL);
    Couple<Color> green = Theme.p((Theme.Key)Theme.Key.BUTTON_SUCCESS);
    private IconButton validateSetting;

    public DestinationScreen(RocketControlsBlockEntity be) {
        super((Component)Lang.translateDirect((String)"gui.destination_screen.title", (Object[])new Object[0]));
        this.blockEntity = be;
        this.initialPosMap = new HashMap<String, BlockPos>(be.initialPosMap);
        this.background = GuiTexturesInit.ROCKET_CONTROLS;
        this.currentDimension = be.m_58904_().m_46472_().m_135782_();
        this.mapOfAccessibleDimensionAndV = new HashMap<ResourceLocation, RocketAccessibleDimension.AccessibilityParameter>(CSDimensionUtil.getTravelMap().get(this.currentDimension).adjacentDimensions());
        this.buttonVector = new Vector(this.mapOfAccessibleDimensionAndV.size());
        this.destinationChanged = false;
    }

    protected void m_7856_() {
        this.setWindowSize(226, 226);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.launchButton = new ExtendedButton(x + 141, y + 198, 64, 20, (Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.launch"), $ -> {
            if (this.destination == null) {
                return;
            }
            PacketInit.getChannel().sendToServer((Object)RocketAssemblePacket.tryAssemble(this.blockEntity.m_58899_(), this.destination));
            this.m_7379_();
        });
        this.m_142416_((GuiEventListener)this.launchButton);
        this.destinationCost = new LabeledBoxWidget(x + 172, y + 20, (Component)Component.m_237113_((String)"  500 "));
        this.validateSetting = new IconButton(x + 192, y + 103, (ScreenElement)AllIcons.I_CONFIG_SAVE);
        this.validateSetting.setToolTip((Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.send_setting"));
        this.validateSetting.withCallback(() -> {
            BlockPos pos = this.initialPosMap.get(String.valueOf(this.destination));
            if (pos == null) {
                pos = this.blockEntity.m_58899_();
            }
            String X = this.Xinput.m_94155_().replace(" ", "");
            String Z = this.Zinput.m_94155_().replace(" ", "");
            if (CSUtil.isInteger(X)) {
                pos = new BlockPos(Integer.parseInt(X), pos.m_123342_(), pos.m_123343_());
            } else {
                this.Xinput.m_94144_(String.valueOf(pos.m_123341_()));
            }
            if (CSUtil.isInteger(Z)) {
                pos = pos.m_122032_().m_142443_(Integer.parseInt(Z)).m_7949_();
            } else {
                this.Zinput.m_94144_(String.valueOf(pos.m_123343_()));
            }
            this.initialPosMap.put(String.valueOf(this.destination), pos);
            PacketInit.getChannel().sendToServer((Object)RocketControlsSettingsPacket.sendSettings(this.blockEntity.m_58899_(), this.initialPosMap));
        });
        this.Xinput = new EditBox(this.f_96547_, x + 169, y + 63, 50, 14, (Component)Component.m_237113_((String)""));
        this.Zinput = new EditBox(this.f_96547_, x + 169, y + 83, 50, 14, (Component)Component.m_237113_((String)""));
        this.m_142416_((GuiEventListener)this.Xinput);
        this.m_142416_((GuiEventListener)this.Zinput);
        this.m_142416_((GuiEventListener)this.validateSetting);
        this.m_142416_((GuiEventListener)this.destinationCost);
        for (int row = 0; row < this.mapOfAccessibleDimensionAndV.size(); ++row) {
            ResourceLocation dim = (ResourceLocation)this.mapOfAccessibleDimensionAndV.keySet().stream().toList().get(row);
            MutableComponent text = Component.m_237115_((String)dim.toString());
            DimSelectBoxWidget widget = new DimSelectBoxWidget(x + 7, y + 20 + 26 * row, 134, 16, (Component)text, dim);
            widget.withCallback(() -> {
                this.destination = widget.getDim();
                this.destinationChanged = true;
            });
            this.buttonVector.add(row, widget);
            this.m_142416_((GuiEventListener)this.buttonVector.get(row));
        }
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        if (this.destination != null) {
            if (this.destinationChanged) {
                BlockPos pos = this.initialPosMap.get(String.valueOf(this.destination));
                if (pos == null) {
                    pos = this.blockEntity.m_58899_();
                }
                this.Xinput.m_94144_(String.valueOf(pos.m_123341_()));
                this.Zinput.m_94144_(String.valueOf(pos.m_123343_()));
            }
            this.Xinput.f_93624_ = true;
            this.Xinput.f_93623_ = true;
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"creatingspace.gui.rocket_controls.pos_selection"), x + 166, y + 43, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"X :"), x + 156, y + 63, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"Z :"), x + 156, y + 83, 0xFFFFFF);
            this.Zinput.f_93624_ = true;
            this.Zinput.f_93623_ = true;
            this.launchButton.f_93623_ = true;
            this.validateSetting.f_93623_ = true;
            this.validateSetting.f_93624_ = true;
            this.destinationCost.f_93624_ = true;
            this.destinationCost.setTextAndTrim((Component)Component.m_237113_((String)String.valueOf(this.mapOfAccessibleDimensionAndV.get(this.destination).deltaV())), true, 112);
        } else {
            this.Xinput.f_93624_ = false;
            this.Xinput.f_93623_ = false;
            this.Zinput.f_93624_ = false;
            this.Zinput.f_93623_ = false;
            this.launchButton.f_93623_ = false;
            this.validateSetting.f_93623_ = false;
            this.validateSetting.f_93624_ = false;
            this.destinationCost.f_93624_ = false;
        }
        for (int row = 0; row < this.mapOfAccessibleDimensionAndV.size(); ++row) {
            DimSelectBoxWidget widget = this.buttonVector.get(row);
            if (this.destination == widget.getDim()) {
                widget.withBorderColors(this.green);
                continue;
            }
            if (this.destination == null) continue;
            widget.withBorderColors(this.red);
        }
        this.destinationChanged = false;
    }

    public void m_86600_() {
        super.m_86600_();
        this.handleTooltips();
    }

    protected void handleTooltips() {
        if (this.destination == null) {
            return;
        }
        if (this.destinationCost != null) {
            LabeledBoxWidget button = this.destinationCost;
            MutableComponent tooltipText = Component.m_237115_((String)"creatingspace.gui.rocket_controls.destination_cost");
            if (!button.getToolTip().contains(tooltipText)) {
                button.getToolTip().add(tooltipText);
            }
        }
    }

    private void fillToolTip(IconButton button, String tooltipKey) {
        if (!button.m_198029_()) {
            return;
        }
        List tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent((Component)Component.m_237115_((String)("creatingspace.gui.rocket_controls." + tooltipKey + ".description")), (TooltipHelper.Palette)TooltipHelper.Palette.ALL_GRAY));
    }
}

