/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.client.gui.screen;

import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.design.ExhaustPackType;
import com.rae.creatingspace.api.design.PowerPackType;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.client.gui.menu.EngineerTableMenu;
import com.rae.creatingspace.init.EngineMaterialInit;
import com.rae.creatingspace.init.MiscInit;
import com.rae.creatingspace.init.PacketInit;
import com.rae.creatingspace.init.graphics.GuiTexturesInit;
import com.rae.creatingspace.init.ingameobject.ItemInit;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.saved.UnlockedDesignManager;
import com.rae.creatingspace.server.blockentities.RocketEngineerTableBlockEntity;
import com.rae.creatingspace.server.items.EngineFabricationBlueprint;
import com.rae.creatingspace.utilities.CSUtil;
import com.rae.creatingspace.utilities.packet.EngineerTableCraft;
import com.rae.creatingspace.utilities.packet.RocketEngineerTableSync;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ForgeSlider;
import org.jetbrains.annotations.NotNull;

public class EngineerTableScreen
extends AbstractSimiContainerScreen<EngineerTableMenu> {
    private final Component availableExhaustTypeTitle = Component.m_237115_((String)"gui.engineer_table_screen.available_exhaust");
    private final Component availablePowerTypeTitle = Component.m_237115_((String)"gui.engineer_table_screen.available_power");
    private final Component availablePropellantTypeTitle = Component.m_237115_((String)"gui.engineer_table_screen.available_propellants");
    private final Component thrustTitle = Component.m_237115_((String)"gui.engineer_table_screen.thrust_selection");
    private final Component sizeTitle = Component.m_237115_((String)"gui.engineer_table_screen.size_selection");
    private List<PowerPackType> powerPackTypes;
    private List<ExhaustPackType> exhaustPackTypes;
    private List<ResourceLocation> powerPackTypeLocations;
    private List<ResourceLocation> exhaustPackTypeLocations;
    private List<ResourceLocation> propellantTypeLocations;
    private List<PropellantType> propellantTypes;
    private ScrollInput setPowerPackType;
    private Label powerPackLabel;
    private ScrollInput setExhaustPackType;
    private Label exhaustPackLabel;
    private ScrollInput setPropellantType;
    private Label propellantLabel;
    private ScrollInput engineSizeInput;
    private Label engineSizeLabel;
    private ScrollInput engineThrustInput;
    private Label engineThrustLabel;
    private ForgeSlider expansionRatioSlider;
    private GuiTexturesInit background = GuiTexturesInit.ROCKET_ENGINEER_TABLE;
    private GuiTexturesInit input = GuiTexturesInit.ROCKET_ENGINEER_TABLE_INPUT;
    private IconButton confirmButton;
    private Label realISPLabel;
    private Label materialLevelLabel;
    private Label massLabel;
    float engineIsp = 0.0f;
    float engineMass = 0.0f;
    int materialLevel = 0;

    public EngineerTableScreen(EngineerTableMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(0, -8);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.exhaustPackLabel = new Label(x + 133, y + 20, Components.immutableEmpty()).withShadow();
        this.exhaustPackLabel.text = Components.immutableEmpty();
        this.exhaustPackTypes = new ArrayList<ExhaustPackType>();
        this.exhaustPackTypeLocations = new ArrayList<ResourceLocation>();
        this.propellantTypeLocations = new ArrayList<ResourceLocation>();
        this.propellantTypes = new ArrayList<PropellantType>();
        this.propellantLabel = new Label(x + 7, y + 135, Components.immutableEmpty()).withShadow();
        this.propellantLabel.text = Components.immutableEmpty();
        this.propellantTypes = new ArrayList<PropellantType>();
        ArrayList availablePropellantType = new ArrayList();
        PropellantTypeInit.getSyncedPropellantRegistry().m_6579_().forEach(ro -> {
            availablePropellantType.add(Component.m_237115_((String)("propellant_type." + ((ResourceKey)ro.getKey()).m_135782_().m_135827_() + "." + ((ResourceKey)ro.getKey()).m_135782_().m_135815_())).m_7220_((Component)Component.m_237115_((String)"creatingspace.gui.engineer_table.max_isp").m_130946_(String.valueOf(((PropellantType)ro.getValue()).getMaxISP()))));
            this.propellantTypes.add((PropellantType)ro.getValue());
            this.propellantTypeLocations.add(((ResourceKey)ro.getKey()).m_135782_());
        });
        this.setPropellantType = new SelectionScrollInput(x + 7, y + 135, 100, 18).forOptions(availablePropellantType).titled(this.availablePropellantTypeTitle.m_6879_()).writingTo(this.propellantLabel).addHint(Component.m_237115_((String)"creatingspace.gui.engineer_table.propellant_type_hint")).setState(this.propellantTypeLocations.indexOf(((EngineerTableMenu)this.m_6262_()).getSyncData().propellantType())).calling(i -> this.syncWithBE());
        this.m_142416_((GuiEventListener)this.setPropellantType);
        this.m_142416_((GuiEventListener)this.propellantLabel);
        ArrayList availableExhaustType = new ArrayList();
        MiscInit.getSyncedExhaustPackRegistry().m_6579_().forEach(ro -> {
            if (!((ExhaustPackType)ro.getValue()).getAllowedPropellants().isEmpty() && UnlockedDesignManager.getExhaustUnlocked(((EngineerTableMenu)this.m_6262_()).player).contains(((ResourceKey)ro.getKey()).m_135782_())) {
                availableExhaustType.add(Component.m_237115_((String)("exhaust_pack_type." + ((ResourceKey)ro.getKey()).m_135782_().m_135827_() + "." + ((ResourceKey)ro.getKey()).m_135782_().m_135815_())));
                this.exhaustPackTypeLocations.add(((ResourceKey)ro.getKey()).m_135782_());
                this.exhaustPackTypes.add((ExhaustPackType)ro.getValue());
            }
        });
        this.setExhaustPackType = new SelectionScrollInput(x + 133, y + 20, 100, 18).forOptions(availableExhaustType).titled(this.availableExhaustTypeTitle.m_6879_()).writingTo(this.exhaustPackLabel).setState(this.exhaustPackTypeLocations.indexOf(((EngineerTableMenu)this.m_6262_()).getSyncData().exhaustPackType())).calling(state -> {
            ExhaustPackType type = this.exhaustPackTypes.get((int)state);
            this.removeWidgets(new GuiEventListener[]{this.expansionRatioSlider});
            this.expansionRatioSlider = new ForgeSlider(x + 10, y + 220, 110, 20, (Component)Component.m_237115_((String)"creatingspace.gui.engineer_table.expansion_ratio"), (Component)Component.m_237119_(), (double)type.getMinExpansionRatio(), (double)type.getMaxExpansionRatio(), (double)((type.getMaxExpansionRatio() + type.getMinExpansionRatio()) / 2.0f), true);
            this.m_142416_((GuiEventListener)this.expansionRatioSlider);
            this.syncWithBE();
        });
        this.m_142416_((GuiEventListener)this.setExhaustPackType);
        this.m_142416_((GuiEventListener)this.exhaustPackLabel);
        this.powerPackLabel = new Label(x + 7, y + 20, Components.immutableEmpty()).withShadow();
        this.powerPackLabel.text = Components.immutableEmpty();
        this.powerPackTypes = new ArrayList<PowerPackType>();
        this.powerPackTypeLocations = new ArrayList<ResourceLocation>();
        ArrayList availablePowerType = new ArrayList();
        MiscInit.getSyncedPowerPackRegistry().m_6579_().forEach(ro -> {
            if (!((PowerPackType)ro.getValue()).getAllowedPropellants().isEmpty() && UnlockedDesignManager.getPowerPackUnlocked(((EngineerTableMenu)this.m_6262_()).player).contains(((ResourceKey)ro.getKey()).m_135782_())) {
                availablePowerType.add(Component.m_237115_((String)("power_pack_type." + ((ResourceKey)ro.getKey()).m_135782_().m_135827_() + "." + ((ResourceKey)ro.getKey()).m_135782_().m_135815_())));
                this.powerPackTypeLocations.add(((ResourceKey)ro.getKey()).m_135782_());
                this.powerPackTypes.add((PowerPackType)ro.getValue());
            }
        });
        this.setPowerPackType = new SelectionScrollInput(x + 7, y + 20, 100, 18).forOptions(availablePowerType).titled(this.availablePowerTypeTitle.m_6879_()).writingTo(this.powerPackLabel).setState(this.powerPackTypeLocations.indexOf(((EngineerTableMenu)this.m_6262_()).getSyncData().powerPackType())).calling(state -> {
            this.syncWithBE();
            this.updateSelectors();
        });
        this.m_142416_((GuiEventListener)this.setPowerPackType);
        this.m_142416_((GuiEventListener)this.powerPackLabel);
        this.expansionRatioSlider = new ForgeSlider(x + 10, y + 220, 110, 20, (Component)Component.m_237115_((String)"creatingspace.gui.engineer_table.expansion_ratio"), (Component)Component.m_237119_(), 2.0, 100.0, (double)((EngineerTableMenu)this.m_6262_()).getSyncData().expansionRatio(), true);
        this.m_142416_((GuiEventListener)this.expansionRatioSlider);
        this.engineSizeLabel = new Label(x + 7, y + 156, Components.immutableEmpty()).withShadow();
        this.engineSizeLabel.text = Components.immutableEmpty();
        this.engineSizeInput = new ScrollInput(x + 7, y + 156, 50, 18).withRange(1, Integer.MAX_VALUE).titled(this.sizeTitle.m_6879_()).writingTo(this.engineSizeLabel).addHint(Component.m_237115_((String)"creatingspace.gui.engineer_table.engine_size_hint")).setState(((EngineerTableMenu)this.m_6262_()).getSyncData().size()).format(i -> Components.literal((String)(i + " mb"))).calling(state -> this.syncWithBE());
        this.engineThrustLabel = new Label(x + 7, y + 178, Components.immutableEmpty()).withShadow();
        this.engineThrustLabel.text = Components.immutableEmpty();
        this.engineThrustInput = new ScrollInput(x + 7, y + 178, 50, 18).withRange(1, Integer.MAX_VALUE).titled(this.thrustTitle.m_6879_()).writingTo(this.engineThrustLabel).addHint(Component.m_237115_((String)"creatingspace.gui.engineer_table.engine_thrust_hint")).withShiftStep(10000).withStepFunction(c -> c.shift ? 100000 : 1000).setState(((RocketEngineerTableBlockEntity)((Object)((EngineerTableMenu)this.m_6262_()).contentHolder)).thrust).format(i -> Components.literal((String)(CSUtil.scientificNbrFormatting(Float.valueOf(i.intValue()), 4) + "N"))).calling(state -> this.syncWithBE());
        this.engineThrustInput.onChanged();
        this.engineSizeInput.onChanged();
        this.m_142416_((GuiEventListener)this.engineSizeLabel);
        this.m_142416_((GuiEventListener)this.engineThrustLabel);
        this.m_142416_((GuiEventListener)this.engineSizeInput);
        this.m_142416_((GuiEventListener)this.engineThrustInput);
        this.confirmButton = (IconButton)new IconButton(x + 258, y + 100, (ScreenElement)AllIcons.I_CONFIRM).withCallback(() -> this.craftEngine(((RocketEngineerTableBlockEntity)((Object)((Object)((EngineerTableMenu)this.m_6262_()).contentHolder))).m_58899_(), this.propellantTypeLocations.get(this.setPropellantType.getState()), this.exhaustPackTypeLocations.get(this.setExhaustPackType.getState()), this.powerPackTypeLocations.get(this.setPowerPackType.getState()), this.engineIsp, this.engineMass, this.engineThrustInput.getState()));
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.setPowerPackType.onChanged();
        this.realISPLabel = new Label(x + 260, y + 35 + 6, (Component)Component.m_237119_());
        this.materialLevelLabel = new Label(x + 260, y + 50 + 6, (Component)Component.m_237119_());
        this.massLabel = new Label(x + 260, y + 65 + 6, (Component)Component.m_237119_());
        this.m_142416_((GuiEventListener)this.realISPLabel);
        this.m_142416_((GuiEventListener)this.materialLevelLabel);
        this.m_142416_((GuiEventListener)this.massLabel);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width) + 50;
        int invY = this.f_97736_ + this.background.height + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(graphics, x, y, Color.WHITE);
        if (!(this.setPowerPackType == null || this.setExhaustPackType == null || this.powerPackTypes.isEmpty() || this.propellantTypes.isEmpty() || this.exhaustPackTypes.isEmpty())) {
            GuiTexturesInit.render(CreatingSpace.resource("textures/gui/rocket_engineer_table/" + this.powerPackTypeLocations.get(this.setPowerPackType.getState()).m_135815_() + ".png"), graphics, x + 5, y + 43, 0, 0, 121, 78, 128, 128, Color.WHITE);
            GuiTexturesInit.render(CreatingSpace.resource("textures/gui/rocket_engineer_table/" + this.exhaustPackTypeLocations.get(this.setExhaustPackType.getState()).m_135815_() + ".png"), graphics, x + 5 + 121, y + 43, 0, 0, 121, 78, 128, 128, Color.WHITE);
            this.input.render(graphics, x, y + this.background.height, Color.WHITE);
            PropellantType prop = this.propellantTypes.get(this.setPropellantType.getState());
            PowerPackType powerPack = this.powerPackTypes.get(this.setPowerPackType.getState());
            ExhaustPackType exhaustPackType = this.exhaustPackTypes.get(this.setExhaustPackType.getState());
            float pressure = prop.getChamberPressure(this.engineThrustInput.getState(), (float)this.engineSizeInput.getState() / 1000.0f, powerPack.getCombustionEfficiency(), this.expansionRatioSlider.getValueInt()) / 100000.0f;
            float temperature = prop.getCombustionTemperature(powerPack.getCombustionEfficiency()).intValue();
            this.engineIsp = prop.getRealIsp(powerPack.getCombustionEfficiency(), this.expansionRatioSlider.getValueInt());
            this.realISPLabel.text = Component.m_237110_((String)"creatingspace.gui.engineer_table.isp", (Object[])new Object[]{(int)this.engineIsp});
            this.engineMass = exhaustPackType.getMass((float)this.engineSizeInput.getState() / 1000.0f, this.expansionRatioSlider.getValueInt());
            this.materialLevel = EngineMaterialInit.getLevelFor(temperature, pressure);
            this.materialLevelLabel.text = Component.m_237110_((String)"creatingspace.gui.engineer_table.material_level", (Object[])new Object[]{this.materialLevel});
            if (300 < mouseX && 400 > mouseX && 80 > mouseY && 50 < mouseY) {
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                components.add(Component.m_237110_((String)"creatingspace.gui.engineer_table.engine_temperature", (Object[])new Object[]{prop.getCombustionTemperature(powerPack.getCombustionEfficiency()).intValue()}));
                components.add(Component.m_237110_((String)"creatingspace.gui.engineer_table.engine_pressure", (Object[])new Object[]{CSUtil.scientificNbrFormatting(Float.valueOf(pressure), 3)}));
                graphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
            }
            this.massLabel.text = Component.m_237110_((String)"creatingspace.gui.engineer_table.engine_mass", (Object[])new Object[]{CSUtil.scientificNbrFormatting(Float.valueOf(this.engineMass / 1000.0f), 3)});
        } else if (this.exhaustPackTypes.isEmpty() || this.powerPackTypes.isEmpty()) {
            this.m_7379_();
        }
    }

    private void craftEngine(BlockPos blockEntityPos, ResourceLocation propellantType, ResourceLocation exhaustType, ResourceLocation powerPackType, float isp, float mass, float thrust) {
        float efficiency = isp / (float)((PropellantType)PropellantTypeInit.getSyncedPropellantRegistry().m_7745_(propellantType)).getMaxISP().intValue();
        ItemStack engineBlueprint = ((EngineFabricationBlueprint)((EngineFabricationBlueprint)((Object)ItemInit.ENGINE_BLUEPRINT.get())).m_5456_()).getBlueprintForEngine(this.engineSizeInput.getState(), this.expansionRatioSlider.getValueInt(), this.materialLevel, (int)thrust, efficiency, propellantType, exhaustType, powerPackType);
        PacketInit.getChannel().sendToServer((Object)EngineerTableCraft.sendCraft(blockEntityPos, engineBlueprint));
    }

    private void syncWithBE() {
        CompoundTag syncData = new CompoundTag();
        try {
            syncData.m_128405_("thrust", this.engineThrustInput.getState());
            syncData.m_128405_("size", this.engineSizeInput.getState());
            syncData.m_128405_("expansionRatio", (int)this.expansionRatioSlider.getValue());
            syncData.m_128365_("exhaustPack", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.exhaustPackTypeLocations.get(this.setExhaustPackType.getState())).result().orElse(new CompoundTag()));
            syncData.m_128365_("powerPack", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.powerPackTypeLocations.get(this.setPowerPackType.getState())).result().orElse(new CompoundTag()));
            syncData.m_128365_("propellantType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.propellantTypeLocations.get(this.setPropellantType.getState())).result().orElse(new CompoundTag()));
            PacketInit.getChannel().sendToServer((Object)RocketEngineerTableSync.sendSettings(((RocketEngineerTableBlockEntity)((Object)((EngineerTableMenu)this.m_6262_()).contentHolder)).m_58899_(), syncData));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSelectors() {
        List<ResourceLocation> propsPowerPack = this.powerPackTypes.get(this.setPowerPackType.getState()).getAllowedPropellants();
        List<ResourceLocation> propsExhaustPack = this.exhaustPackTypes.get(this.setExhaustPackType.getState()).getAllowedPropellants();
        ArrayList<MutableComponent> availablePropellants = new ArrayList<MutableComponent>();
        this.propellantTypeLocations = new ArrayList<ResourceLocation>();
        this.propellantTypes = new ArrayList<PropellantType>();
        propsPowerPack.forEach(location -> {
            if (propsExhaustPack.contains(location)) {
                availablePropellants.add(Component.m_237115_((String)("propellant_type." + location.m_135827_() + "." + location.m_135815_())));
                this.propellantTypeLocations.add((ResourceLocation)location);
                this.propellantTypes.add((PropellantType)PropellantTypeInit.getSyncedPropellantRegistry().m_7745_(location));
            }
        });
        this.setPropellantType.setState(0);
        if (availablePropellants.isEmpty()) {
            availablePropellants.add(Component.m_237119_());
        }
        ((SelectionScrollInput)this.setPropellantType).forOptions(availablePropellants);
        this.setPropellantType.f_93624_ = !availablePropellants.isEmpty();
        this.setPropellantType.onChanged();
    }
}

