/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.client.gui.screen;

import com.rae.creatingspace.client.gui.screen.elements.BackgroundScrollInput;
import com.rae.creatingspace.client.gui.screen.elements.SliderWidget;
import com.rae.creatingspace.init.PacketInit;
import com.rae.creatingspace.init.graphics.GuiTexturesInit;
import com.rae.creatingspace.server.blockentities.atmosphere.SealerBlockEntity;
import com.rae.creatingspace.utilities.packet.SealerSettings;
import com.rae.creatingspace.utilities.packet.SealerTrySealing;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class SealerScreen
extends AbstractSimiScreen {
    private Button startButton;
    private boolean isSetting = false;
    private Indicator sealedIndicator;
    private SliderWidget o2Gauge;
    private IconButton settingButton;
    private Indicator settingIndicator;
    private ScrollInput setRangeInput;
    private Label setRangeLabel;
    private IconButton setRetryButton;
    private Indicator retryIndicator;
    private final SealerBlockEntity blockEntity;
    private final GuiTexturesInit background;
    private int rangeSetting = 10;
    private boolean retrySetting = false;

    public SealerScreen(SealerBlockEntity be) {
        super((Component)Lang.translateDirect((String)"gui.destination_screen.title", (Object[])new Object[0]));
        this.blockEntity = be;
        this.retrySetting = be.isAutomaticRetry();
        this.rangeSetting = be.getRange();
        this.background = GuiTexturesInit.SEALER_BACKGROUND;
    }

    protected void m_7856_() {
        this.setWindowSize(226, 124);
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.startButton = new ExtendedButton(x + 153, y + 100, 64, 20, (Component)Component.m_237115_((String)"creatingspace.gui.sealer.try_seal"), $ -> PacketInit.getChannel().sendToServer((Object)SealerTrySealing.trySealing(this.blockEntity.m_58899_())));
        this.m_142416_((GuiEventListener)this.startButton);
        this.settingButton = new IconButton(x + 6, y + 100, (ScreenElement)AllIcons.I_PLACEMENT_SETTINGS);
        this.settingButton.withCallback(this::switchSetting);
        this.settingButton.setToolTip((Component)Component.m_237115_((String)"creatingspace.gui.sealer.settings"));
        this.setRangeLabel = new Label(x + 80, y + 100 + 9 - 4, Components.immutableEmpty()).withShadow();
        this.setRangeInput = new BackgroundScrollInput(x + 70, y + 100, 64, 18);
        this.setRangeInput.withRange(0, 1000).writingTo(this.setRangeLabel).titled(Component.m_237115_((String)"creatingspace.gui.sealer.range")).calling(value -> {
            this.rangeSetting = value;
            this.sendSettings(this.blockEntity.m_58899_());
        }).setState(this.rangeSetting);
        this.setRangeInput.f_93624_ = false;
        this.setRangeInput.f_93623_ = false;
        this.setRangeLabel.f_93624_ = false;
        this.setRangeInput.onChanged();
        this.m_142416_((GuiEventListener)this.setRangeInput);
        this.m_142416_((GuiEventListener)this.setRangeLabel);
        this.setRetryButton = new IconButton(x + 48, y + 100, (ScreenElement)AllIcons.I_PLACEMENT_SETTINGS);
        this.setRetryButton.withCallback(() -> {
            this.retrySetting = !this.retrySetting;
            this.sendSettings(this.blockEntity.m_58899_());
        });
        this.setRetryButton.setToolTip((Component)Component.m_237115_((String)"creatingspace.gui.sealer.automatic_retry"));
        this.setRetryButton.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.settingButton);
        this.m_142416_((GuiEventListener)this.setRetryButton);
        this.settingIndicator = new Indicator(x + 6, y + 94, (Component)Component.m_237115_((String)"creatingspace.gui.sealer.settings"));
        this.retryIndicator = new Indicator(x + 48, y + 94, (Component)Component.m_237115_((String)"creatingspace.gui.sealer.automatic_retry"));
        this.retryIndicator.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.settingIndicator);
        this.m_142416_((GuiEventListener)this.retryIndicator);
        this.o2Gauge = new SliderWidget(x + 6, y + 19, 32, 64);
        this.m_142416_((GuiEventListener)this.o2Gauge);
        this.sealedIndicator = new Indicator(x + 199, y + 94, (Component)Component.m_237115_((String)"creatingspace.gui.sealer.isSealed"));
        this.m_142416_((GuiEventListener)this.sealedIndicator);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.o2Gauge.setValues(this.blockEntity.o2amount, this.blockEntity.prevO2amount);
        boolean roomIsSealed = this.blockEntity.roomIsSealed;
        this.sealedIndicator.state = roomIsSealed ? Indicator.State.GREEN : Indicator.State.RED;
        this.retryIndicator.state = this.retrySetting ? Indicator.State.GREEN : Indicator.State.RED;
        this.startButton.f_93623_ = !this.blockEntity.isTrying();
        int nbrOfBlock = this.blockEntity.lastRoomSize;
        float speed = this.blockEntity.getSpeed();
        graphics.m_280168_().m_85836_();
        graphics.m_280056_(this.f_96547_, String.valueOf(nbrOfBlock), x + 139, y + 55, 0xFFFFFF, false);
        graphics.m_280056_(this.f_96547_, String.valueOf(SealerBlockEntity.o2consumption(nbrOfBlock)), x + 73, y + 43, 0xFFFFFF, false);
        int speedRequirement = SealerBlockEntity.speedRequirement(nbrOfBlock);
        graphics.m_280056_(this.f_96547_, String.valueOf(speedRequirement), x + 73, y + 66, Math.abs(speed) >= (float)speedRequirement ? 65365 : 0xFF5500, false);
        graphics.m_280168_().m_85849_();
    }

    public void switchSetting() {
        this.isSetting = !this.isSetting;
        this.settingIndicator.state = this.isSetting ? Indicator.State.ON : Indicator.State.OFF;
        this.setRangeInput.f_93624_ = this.isSetting;
        this.setRangeInput.f_93623_ = this.isSetting;
        this.setRangeLabel.f_93624_ = this.isSetting;
        this.setRetryButton.f_93624_ = this.isSetting;
        this.retryIndicator.f_93624_ = this.isSetting;
    }

    public void sendSettings(BlockPos blockEntityPos) {
        PacketInit.getChannel().sendToServer((Object)SealerSettings.sendSettings(blockEntityPos, this.rangeSetting, this.retrySetting));
    }
}

