/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.client.renderer.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.rae.creatingspace.server.blockentities.atmosphere.RoomPressuriserBlockEntity;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RoomPressuriserInstance
extends KineticBlockEntityInstance<RoomPressuriserBlockEntity> {
    protected final RotatingData firstShaft;
    protected final RotatingData oppositeShaft;
    protected final RotatingData fan;
    final Direction direction;
    private final Direction opposite;

    public RoomPressuriserInstance(MaterialManager materialManager, RoomPressuriserBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.direction = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.opposite = this.direction.m_122424_();
        int blockLight = this.world.m_45517_(LightLayer.BLOCK, this.pos);
        int skyLight = this.world.m_45517_(LightLayer.SKY, this.pos);
        Direction.Axis localAxis = this.axis;
        this.firstShaft = (RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, Direction.m_122387_((Direction.Axis)localAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).createInstance();
        this.oppositeShaft = (RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, Direction.m_122387_((Direction.Axis)localAxis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)).createInstance();
        this.firstShaft.setRotationalSpeed(this.getBlockEntitySpeed()).setRotationOffset(this.getRotationOffset(localAxis)).setColor((KineticBlockEntity)blockEntity).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.oppositeShaft.setRotationalSpeed(-this.getBlockEntitySpeed()).setRotationOffset(this.getRotationOffset(localAxis)).setColor((KineticBlockEntity)blockEntity).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.fan = (RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(AllPartialModels.ENCASED_FAN_INNER, this.blockState, this.opposite).createInstance();
        localAxis = this.direction.m_122434_();
        this.fan.setRotationalSpeed(this.getFanSpeed()).setRotationOffset(this.getRotationOffset(localAxis)).setColor((KineticBlockEntity)blockEntity).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.setup(this.firstShaft);
        this.setup(this.oppositeShaft);
        this.setup(this.fan, localAxis);
    }

    private float getFanSpeed() {
        float speed = ((RoomPressuriserBlockEntity)this.blockEntity).getSpeed() * 5.0f;
        if (speed > 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)80.0f, (float)1280.0f);
        }
        if (speed < 0.0f) {
            speed = Mth.m_14036_((float)speed, (float)-1280.0f, (float)-80.0f);
        }
        return speed;
    }

    public void update() {
        this.updateRotation(this.firstShaft);
        this.updateRotation(this.oppositeShaft);
        this.updateRotation(this.fan, this.direction.m_122434_(), this.getFanSpeed());
    }

    public void updateLight() {
        BlockPos firstSide = this.pos.m_121945_(Direction.m_122387_((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        this.relight(firstSide, new FlatLit[]{this.firstShaft});
        BlockPos oppositeSide = this.pos.m_121945_(Direction.m_122387_((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        this.relight(oppositeSide, new FlatLit[]{this.oppositeShaft});
        BlockPos inFront = this.pos.m_121945_(this.direction);
        this.relight(inFront, new FlatLit[]{this.fan});
    }

    public void remove() {
        this.firstShaft.delete();
        this.oppositeShaft.delete();
        this.fan.delete();
    }
}

