/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.compat.jei;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.compat.jei.CryoSubtypeInterpreter;
import com.rae.creatingspace.compat.jei.category.AirLiquefyingCategory;
import com.rae.creatingspace.compat.jei.category.ChemicalSynthesisCategory;
import com.rae.creatingspace.compat.jei.category.MechanicalElectrolysisCategory;
import com.rae.creatingspace.init.RecipeInit;
import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.recipes.AirLiquefyingRecipe;
import com.rae.creatingspace.server.blocks.CryogenicTankBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.ToolboxColoringRecipeMaker;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CSJei
implements IModPlugin {
    private static final ResourceLocation ID = CreatingSpace.resource("jei_plugin");
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    private void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory<BasinRecipe> chemical = this.builder(BasinRecipe.class).addTypedRecipes(RecipeInit.CHEMICAL_SYNTHESIS).catalyst(() -> BlockInit.CATALYST_CARRIER.get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((ItemLike)BlockInit.CATALYST_CARRIER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 103).build("chemical", (CreateRecipeCategory.Factory<BasinRecipe>)((CreateRecipeCategory.Factory)ChemicalSynthesisCategory::standard));
        CreateRecipeCategory<BasinRecipe> electrolysis = this.builder(BasinRecipe.class).addTypedRecipes(RecipeInit.MECHANICAL_ELECTROLYSIS).catalyst(() -> BlockInit.MECHANICAL_ELECTROLYZER.get()).catalyst(() -> ((BlockEntry)AllBlocks.BASIN).get()).doubleItemIcon((ItemLike)BlockInit.MECHANICAL_ELECTROLYZER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 103).build("electrolysis", (CreateRecipeCategory.Factory<BasinRecipe>)((CreateRecipeCategory.Factory)MechanicalElectrolysisCategory::standard));
        CreateRecipeCategory<AirLiquefyingRecipe> airLiquefying = this.builder(AirLiquefyingRecipe.class).addTypedRecipes(RecipeInit.AIR_LIQUEFYING).catalyst(() -> BlockInit.AIR_LIQUEFIER.get()).itemIcon((ItemLike)BlockInit.AIR_LIQUEFIER.get()).emptyBackground(177, 103).build("air_liquefying", (CreateRecipeCategory.Factory<AirLiquefyingRecipe>)((CreateRecipeCategory.Factory)AirLiquefyingCategory::new));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
        registration.addRecipes(RecipeTypes.CRAFTING, ToolboxColoringRecipeMaker.createRecipes().toList());
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        super.registerIngredients(registration);
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        CryoSubtypeInterpreter interpreter = new CryoSubtypeInterpreter();
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((CryogenicTankBlock)((Object)BlockInit.CRYOGENIC_TANK.get())).m_5456_(), (IIngredientSubtypeInterpreter)interpreter);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(CreatingSpace.resource(name), this.recipeClass), (Component)Component.m_237115_((String)("creatingspace.recipe." + name)), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            CSJei.this.allCategories.add(category);
            return category;
        }
    }
}

