/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.init.ingameobject;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.init.TagsInit;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.OpenEndedPipe;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.utility.Color;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Vector3f;

public class FluidInit {
    public static final FluidEntry<VirtualFluid> LIQUID_METHANE = FluidInit.registrateCustomVirtualLiquid("liquid_methane").properties(p -> p.viscosity(1000).temperature(90).density(500).canExtinguish(true)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_METHANE.tag}).register();
    public static final FluidEntry<VirtualFluid> LIQUID_OXYGEN = FluidInit.registrateCustomVirtualLiquid("liquid_oxygen").properties(p -> p.viscosity(1000).temperature(90).density(1141)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_OXYGEN.tag}).register();
    public static final FluidEntry<VirtualFluid> LIQUID_HYDROGEN = FluidInit.registrateCustomVirtualLiquid("liquid_hydrogen").properties(p -> p.viscosity(1000).temperature(10).density(70)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_HYDROGEN.tag}).register();
    public static final FluidEntry<VirtualFluid> LIQUID_CO2 = FluidInit.registrateCustomVirtualLiquid("liquid_co2").properties(p -> p.viscosity(1000).temperature(180).density(1100)).tag(new TagKey[]{TagsInit.CustomFluidTags.LIQUID_CO2.tag}).register();

    private static ResourceLocation customStill(String name) {
        return CreatingSpace.resource("fluid/" + name + "_still");
    }

    private static ResourceLocation customFlowing(String name) {
        return CreatingSpace.resource("fluid/" + name + "_flow");
    }

    private static FluidBuilder<VirtualFluid, CreateRegistrate> registrateCustomVirtualLiquid(String name) {
        return CreatingSpace.REGISTRATE.virtualFluid(name, FluidInit.customStill(name), FluidInit.customFlowing(name), CreateRegistrate::defaultFluidType, VirtualFluid::new);
    }

    public static void register() {
    }

    public static void registerOpenEndedEffect() {
        OpenEndedPipe.registerEffectHandler((OpenEndedPipe.IEffectHandler)new CryogenicLiquidEffectHandler());
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_HYDROGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50652_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_HYDROGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50126_.m_49966_();
            }
            return Blocks.f_50127_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_OXYGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50652_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_OXYGEN.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50126_.m_49966_();
            }
            return Blocks.f_50127_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_METHANE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return Blocks.f_50652_.m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.WATER_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((VirtualFluid)LIQUID_METHANE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50126_.m_49966_();
            }
            return Blocks.f_50127_.m_49966_();
        }));
    }

    public static class CryogenicLiquidEffectHandler
    implements OpenEndedPipe.IEffectHandler {
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return fluid.getFluid().getFluidType().getTemperature() < 100;
        }

        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            Level world = pipe.getWorld();
            if (world.m_46467_() % 5L != 0L) {
                return;
            }
            List entities = world.m_6443_(LivingEntity.class, pipe.getAOE(), LivingEntity::m_6084_);
            for (LivingEntity entity : entities) {
                entity.m_146924_(true);
                if (!world.f_46443_) continue;
                RandomSource randomsource = world.m_213780_();
                world.m_7106_((ParticleOptions)ParticleTypes.f_175821_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
            }
        }
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

