/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.armor;

import com.rae.creatingspace.init.TagsInit;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class OxygenBacktankUtil {
    private static final List<Function<LivingEntity, List<ItemStack>>> OXYGEN_BACKTANK_SUPPLIERS = new ArrayList<Function<LivingEntity, List<ItemStack>>>();

    public static List<ItemStack> getAllWithOxygen(LivingEntity entity) {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>();
        for (Function<LivingEntity, List<ItemStack>> supplier : OXYGEN_BACKTANK_SUPPLIERS) {
            List<ItemStack> result = supplier.apply(entity);
            for (ItemStack stack : result) {
                if (!OxygenBacktankUtil.hasOxygenRemaining(stack)) continue;
                all.add(stack);
            }
        }
        all.sort((a, b) -> Float.compare(OxygenBacktankUtil.getOxygen(a), OxygenBacktankUtil.getOxygen(b)));
        return all;
    }

    public static boolean hasOxygenRemaining(ItemStack backtank) {
        return OxygenBacktankUtil.getOxygen(backtank) > 0.0f;
    }

    public static float getOxygen(ItemStack backtank) {
        CompoundTag tag = backtank.m_41784_();
        return Math.min(tag.m_128457_("Oxygen"), (float)OxygenBacktankUtil.maxOxygen(backtank));
    }

    public static void consumeOxygen(LivingEntity entity, ItemStack backtank, int i) {
        CompoundTag tag = backtank.m_41784_();
        int maxOxygen = OxygenBacktankUtil.maxOxygen(backtank);
        float oxygen = OxygenBacktankUtil.getOxygen(backtank);
        float newOxygen = Math.max(oxygen - (float)i, 0.0f);
        tag.m_128350_("Oxygen", Math.min(newOxygen, (float)maxOxygen));
        tag.m_128379_("toUpdate", true);
        backtank.m_41751_(tag);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        OxygenBacktankUtil.sendWarning(player, oxygen, newOxygen, (float)maxOxygen / 10.0f);
        OxygenBacktankUtil.sendWarning(player, oxygen, newOxygen, 1.0f);
    }

    private static void sendWarning(ServerPlayer player, float oxygen, float newOxygen, float threshold) {
        if (newOxygen > threshold) {
            return;
        }
        if (oxygen <= threshold) {
            return;
        }
        boolean depleted = threshold == 1.0f;
        MutableComponent component = Lang.translateDirect((String)(depleted ? "oxygenbacktank.depleted" : "backtank.low"), (Object[])new Object[0]);
        AllSoundEvents.DENY.play(player.m_9236_(), null, (Vec3i)player.m_20183_(), 1.0f, 1.25f);
        AllSoundEvents.STEAM.play(player.m_9236_(), null, (Vec3i)player.m_20183_(), 0.5f, 0.5f);
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 40, 10));
        player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Components.literal((String)"\u26a0 ").m_130940_(depleted ? ChatFormatting.RED : ChatFormatting.GOLD).m_7220_((Component)component.m_130940_(ChatFormatting.GRAY))));
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(Components.immutableEmpty()));
    }

    public static int maxOxygen(ItemStack backtank) {
        return OxygenBacktankUtil.maxOxygen(backtank.getEnchantmentLevel((Enchantment)AllEnchantments.CAPACITY.get()));
    }

    public static int maxOxygen(int enchantLevel) {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get() + (Integer)AllConfigs.server().equipment.enchantedBacktankCapacity.get() * enchantLevel;
    }

    public static int maxOxygenWithoutEnchants() {
        return (Integer)AllConfigs.server().equipment.airInBacktank.get();
    }

    public static void addOxygenBacktankSupplier(Function<LivingEntity, List<ItemStack>> supplier) {
        OXYGEN_BACKTANK_SUPPLIERS.add(supplier);
    }

    static {
        OxygenBacktankUtil.addOxygenBacktankSupplier(entity -> {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : entity.m_6168_()) {
                if (!TagsInit.CustomItemTags.OXYGEN_SOURCES.matches(itemStack)) continue;
                stacks.add(itemStack);
            }
            return stacks;
        });
    }
}

