/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.rae.creatingspace.init.RecipeInit;
import com.rae.creatingspace.recipes.AirLiquefyingRecipe;
import com.rae.creatingspace.server.blocks.AirLiquefierBlock;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AirLiquefierBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    protected Recipe<?> currentRecipe;
    private int processingTicks;
    private Object airLiquefyingRecipesKey;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    protected LazyOptional<IFluidHandler> fluidCapability;
    private boolean contentsChanged;
    protected SmartFluidTankBehaviour outputTank;

    public AirLiquefierBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null)});
        });
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction localDir;
        if (cap == ForgeCapabilities.FLUID_HANDLER && (side == (localDir = (Direction)this.m_58900_().m_61143_((Property)AirLiquefierBlock.FACING)).m_122424_() || side == Direction.UP || side == Direction.DOWN)) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick(Level level, BlockPos pos, BlockState state, AirLiquefierBlockEntity blockEntity) {
        super.tick();
        if (!level.m_5776_() && this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        float speed = Math.abs(this.getSpeed());
        if (!level.f_46443_ || this.isVirtual()) {
            if (this.processingTicks < 0) {
                int t;
                float recipeSpeed = 1.0f;
                if (this.currentRecipe instanceof ProcessingRecipe && (t = ((ProcessingRecipe)this.currentRecipe).getProcessingDuration()) != 0) {
                    recipeSpeed = (float)t / 100.0f;
                }
                this.processingTicks = Mth.m_14045_((int)(Mth.m_14173_((int)((int)(512.0f / speed))) * Mth.m_14167_((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
            } else {
                --this.processingTicks;
                if (this.processingTicks == 0) {
                    this.processingTicks = -1;
                    this.applyRecipe();
                    this.sendData();
                }
            }
        }
    }

    public void lazyTick() {
        List<Recipe<?>> recipes;
        super.lazyTick();
        if (this.isSpeedRequirementFulfilled() && this.getSpeed() != 0.0f && this.f_58857_ != null && !this.f_58857_.f_46443_ && !(recipes = this.getMatchingRecipes()).isEmpty()) {
            this.currentRecipe = recipes.get(0);
            this.sendData();
        }
    }

    protected <C extends Container> boolean matchRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        return AirLiquefyingRecipe.match(this, recipe);
    }

    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.MIXER);
    }

    public void continueWithPreviousRecipe() {
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r.m_6671_() == RecipeInit.AIR_LIQUEFYING.getType();
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
        return list.stream().filter(this::matchRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
    }

    protected Object getRecipeCacheKey() {
        return this.airLiquefyingRecipesKey;
    }

    protected void applyRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        if (!AirLiquefyingRecipe.apply(this, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((AirLiquefierBlockEntity)this).award(arg_0));
        if (this.matchRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        this.notifyChangeOfContents();
    }

    protected void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.outputTank.read(nbt, clientPacket);
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        this.outputTank.write(nbt, clientPacket);
        super.write(nbt, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        LangBuilder mbs = Lang.translate((String)"generic.unit.fluidflow", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            String fluidName = fluidStack.getTranslationKey();
            Lang.builder().add(Component.m_237115_((String)fluidName)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)fluids.getTankCapacity(i)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public boolean acceptOutputs(List<FluidStack> outputFluids, boolean simulate) {
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputFluids, simulate);
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<FluidStack> outputFluids, boolean simulate) {
        for (FluidStack fluid : outputFluids) {
            float amount = ((IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0))).fill(fluid, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (amount != 0.0f) continue;
            return false;
        }
        return true;
    }
}

