/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.ingameobject.FluidInit;
import com.rae.creatingspace.init.ingameobject.ItemInit;
import com.rae.creatingspace.server.blocks.ChemicalSynthesizerBlock;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChemicalSynthesizerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ChemicalSynthesizerBlockEntity.this.m_6596_();
            super.onContentsChanged(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.m_41720_() == ItemInit.COAL_DUST.get()) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final LazyOptional<IItemHandlerModifiable> itemOptional = LazyOptional.of(() -> this.inventory);
    private int progress = 0;
    private int maxProgress = 80;
    static int amount = 20;
    private final LazyOptional<IFluidHandler> hydrogenFluidOptional = LazyOptional.of(() -> this.HYDROGEN_TANK);
    private final FluidTank HYDROGEN_TANK = new FluidTank(2000){

        protected void onContentsChanged() {
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_HYDROGEN.matches(stack.getFluid());
        }
    };
    private final LazyOptional<IFluidHandler> methaneFluidOptional = LazyOptional.of(() -> this.METHANE_TANK);
    private final FluidTank METHANE_TANK = new FluidTank(2000){

        protected void onContentsChanged() {
            super.onContentsChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_METHANE.matches(stack.getFluid());
        }
    };

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public ChemicalSynthesizerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick(Level level, BlockPos pos, BlockState state, ChemicalSynthesizerBlockEntity synthesizerBlockEntity) {
        super.tick();
        if (!level.m_5776_()) {
            if (this.syncCooldown > 0) {
                --this.syncCooldown;
                if (this.syncCooldown == 0 && this.queuedSync) {
                    this.sendData();
                }
            }
            if (ChemicalSynthesizerBlockEntity.hasRecipe(synthesizerBlockEntity)) {
                ++synthesizerBlockEntity.progress;
                this.notifyUpdate();
                if (synthesizerBlockEntity.progress >= synthesizerBlockEntity.maxProgress) {
                    ChemicalSynthesizerBlockEntity.craftFluid(synthesizerBlockEntity);
                }
            } else {
                synthesizerBlockEntity.resetProgress();
                this.notifyUpdate();
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftFluid(ChemicalSynthesizerBlockEntity synthesizerBlockEntity) {
        if (ChemicalSynthesizerBlockEntity.hasRecipe(synthesizerBlockEntity)) {
            synthesizerBlockEntity.inventory.extractItem(0, 1, false);
            synthesizerBlockEntity.HYDROGEN_TANK.drain((int)((float)amount * 4.0f / (float)FluidInit.LIQUID_HYDROGEN.getType().getDensity() * 1000.0f), IFluidHandler.FluidAction.EXECUTE);
            Fluid fluid = (Fluid)FluidInit.LIQUID_METHANE.get();
            if (!synthesizerBlockEntity.METHANE_TANK.isEmpty()) {
                fluid = synthesizerBlockEntity.METHANE_TANK.getFluid().getFluid();
            }
            synthesizerBlockEntity.METHANE_TANK.fill(new FluidStack(fluid, (int)((float)amount * 16.0f / (float)FluidInit.LIQUID_METHANE.getType().getDensity() * 1000.0f)), IFluidHandler.FluidAction.EXECUTE);
            synthesizerBlockEntity.resetProgress();
        }
    }

    private static boolean hasRecipe(ChemicalSynthesizerBlockEntity synthesizerBlockEntity) {
        SimpleContainer inventory = new SimpleContainer(synthesizerBlockEntity.inventory.getSlots());
        for (int i = 0; i < synthesizerBlockEntity.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, synthesizerBlockEntity.inventory.getStackInSlot(i));
        }
        boolean hasHydrogenInTank = (float)synthesizerBlockEntity.HYDROGEN_TANK.getFluidAmount() >= (float)amount * 4.0f / (float)FluidInit.LIQUID_HYDROGEN.getType().getDensity() * 1000.0f;
        boolean methaneTankNotFull = (float)synthesizerBlockEntity.METHANE_TANK.getSpace() >= (float)amount * 16.0f / (float)FluidInit.LIQUID_METHANE.getType().getDensity() * 1000.0f;
        boolean hasCarbonInSlot = synthesizerBlockEntity.inventory.getStackInSlot(0).m_41720_() == ItemInit.COAL_DUST.get();
        return hasHydrogenInTank && hasCarbonInSlot && methaneTankNotFull;
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.HYDROGEN_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_HYDROGEN.get(), nbt.m_128451_("hydrogenAmount")));
        this.METHANE_TANK.setFluid(new FluidStack((Fluid)FluidInit.LIQUID_METHANE.get(), nbt.m_128451_("methaneAmount")));
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("hydrogenAmount", this.HYDROGEN_TANK.getFluidAmount());
        nbt.m_128405_("methaneAmount", this.METHANE_TANK.getFluidAmount());
        super.write(nbt, clientPacket);
    }

    public void drop() {
        SimpleContainer inventory = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemOptional.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            Direction localDir = (Direction)this.m_58900_().m_61143_((Property)ChemicalSynthesizerBlock.FACING);
            if (localDir == side.m_122424_()) {
                return this.hydrogenFluidOptional.cast();
            }
            if (localDir == side) {
                return this.methaneFluidOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getMethaneAmount() {
        return this.METHANE_TANK.getFluidAmount();
    }

    public int getHydrogenAmount() {
        return this.HYDROGEN_TANK.getFluidAmount();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        LangBuilder mbs = Lang.translate((String)"generic.unit.fluidflow", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        for (int i = 0; i <= 1; ++i) {
            FluidTank tank = switch (i) {
                case 0 -> this.METHANE_TANK;
                case 1 -> this.HYDROGEN_TANK;
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            String fluidName = switch (i) {
                case 0 -> FluidInit.LIQUID_METHANE.getType().getDescriptionId();
                case 1 -> FluidInit.LIQUID_HYDROGEN.getType().getDescriptionId();
                default -> throw new IllegalStateException("Unexpected value: " + i);
            };
            FluidStack fluidStack = tank.getFluidInTank(0);
            Lang.builder().add(Component.m_237115_((String)fluidName)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        return true;
    }
}

