/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.server.blocks.CryogenicTankBlock;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CryogenicTankBlockEntity
extends SmartBlockEntity
implements Nameable,
IHaveGoggleInformation {
    private final Component defaultName;
    private Component customName;
    public FluidTank TANK = new FluidTank(4000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CryogenicTankBlockEntity.this.notifyUpdate();
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().getFluidType().getTemperature() < 200;
        }
    };
    public LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(() -> this.TANK);
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public CryogenicTankBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.defaultName = CryogenicTankBlockEntity.getDefaultName();
    }

    public static Component getDefaultName() {
        return ((CryogenicTankBlock)((Object)BlockInit.CRYOGENIC_TANK.get())).m_49954_();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component m_7770_() {
        return this.customName;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        CompoundTag tankTag = new CompoundTag();
        tag.m_128365_("Fluid", (Tag)this.TANK.writeToNBT(tankTag));
        super.write(tag, clientPacket);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.TANK.readFromNBT((CompoundTag)tag.m_128423_("Fluid"));
    }

    public void setTank(CompoundTag tag) {
        this.TANK.readFromNBT(tag);
    }

    public FluidTank getTank() {
        return this.TANK;
    }

    public void tick(Level level, BlockPos pos, BlockState state, CryogenicTankBlockEntity cryogenicTankBlockEntity) {
        super.tick();
        if (!level.m_5776_() && this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        LangBuilder mbs = Lang.translate((String)"generic.unit.fluidflow", (Object[])new Object[0]);
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        FluidTank tank = this.TANK;
        String fluidName = this.TANK.getFluid().getFluid().getFluidType().getDescriptionId();
        FluidStack fluidStack = tank.getFluidInTank(0);
        Lang.builder().add(Component.m_237115_((String)fluidName)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)tank.getTankCapacity(0)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

