/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.rae.creatingspace.configs.CSCfgClient;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.utilities.CSUtil;
import com.rae.creatingspace.utilities.data.FlightDataHelper;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public class FlightRecorderBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    FlightDataHelper.RocketAssemblyData lastAssemblyData;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public FlightRecorderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setLastAssemblyData(FlightDataHelper.RocketAssemblyData lastAssemblyData) {
        this.lastAssemblyData = lastAssemblyData;
    }

    public void tick(Level level, BlockPos pos, BlockState state, FlightRecorderBlockEntity blockEntity) {
        super.tick();
        if (!level.m_5776_() && this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    protected void read(CompoundTag nbt, boolean clientPacket) {
        this.setLastAssemblyData(FlightDataHelper.RocketAssemblyData.fromNBT(nbt.m_128469_("lastAssemblyData")));
        super.read(nbt, clientPacket);
    }

    protected void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("lastAssemblyData", (Tag)FlightDataHelper.RocketAssemblyData.toNBT(this.lastAssemblyData));
        super.write(nbt, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String tradKey = "creatingspace.overlay.flight_recorder.";
        Lang.builder().add(Component.m_237115_((String)(tradKey + "title"))).forGoggles(tooltip, 1);
        if (this.lastAssemblyData != null) {
            if (this.lastAssemblyData.hasFailed()) {
                if (this.lastAssemblyData.propellantStatusData().status().isFailReason) {
                    Lang.builder().add(Component.m_237115_((String)(tradKey + "propellant_status." + String.valueOf((Object)this.lastAssemblyData.propellantStatusData().status()).toLowerCase(Locale.ROOT)))).forGoggles(tooltip, 1);
                    for (TagKey<Fluid> fluidTagKey : this.lastAssemblyData.propellantStatusData().consumedMassForEachPropellant().keySet()) {
                        Integer consumedMass = this.lastAssemblyData.propellantStatusData().consumedMassForEachPropellant().get(fluidTagKey);
                        Integer fluidMass = this.lastAssemblyData.propellantStatusData().massForEachPropellant().get(fluidTagKey);
                        if (fluidMass == null) {
                            fluidMass = 0;
                        }
                        if (((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.MASS)) {
                            Lang.builder().add(Component.m_237115_((String)("fluid." + fluidTagKey.f_203868_().m_214298_())).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)CSUtil.scientificNbrFormatting(Float.valueOf((float)fluidMass.intValue() / 1000.0f), 5)).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.metric_ton")).m_130940_(consumedMass >= fluidMass ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN)).m_7220_((Component)Component.m_237113_((String)(" / " + CSUtil.scientificNbrFormatting(Float.valueOf((float)consumedMass.intValue() / 1000.0f), 5))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.metric_ton")).m_130940_(ChatFormatting.GOLD))).forGoggles(tooltip, 2);
                            continue;
                        }
                        if (!((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.VOLUMETRIC)) continue;
                        AtomicReference fluidRef = new AtomicReference();
                        ForgeRegistries.FLUIDS.getEntries().forEach(resourceKeyFluidEntry -> {
                            if (((Fluid)resourceKeyFluidEntry.getValue()).m_205067_(fluidTagKey)) {
                                fluidRef.set((Fluid)resourceKeyFluidEntry.getValue());
                            }
                        });
                        if (fluidRef.get() == null) {
                            Lang.builder().add(Component.m_237113_((String)"Warning : failed to find a fluid in game data")).forGoggles(tooltip, 2);
                            continue;
                        }
                        float fluidVolume = fluidMass / ((Fluid)fluidRef.get()).getFluidType().getDensity();
                        Lang.builder().add(Component.m_237115_((String)("fluid." + fluidTagKey.f_203868_().m_214298_())).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)CSUtil.scientificNbrFormatting(Float.valueOf(fluidVolume), 5)).m_7220_((Component)Component.m_237113_((String)"B")).m_130940_(consumedMass >= fluidMass ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN)).m_7220_((Component)Component.m_237113_((String)(" / " + CSUtil.scientificNbrFormatting(Float.valueOf((float)consumedMass.intValue() / (float)((Fluid)fluidRef.get()).getFluidType().getDensity()), 5))).m_7220_((Component)Component.m_237113_((String)"B")).m_130940_(ChatFormatting.GOLD))).forGoggles(tooltip, 2);
                    }
                }
                if (this.lastAssemblyData.thrust() < this.lastAssemblyData.weight()) {
                    Lang.builder().add(Component.m_237115_((String)(tradKey + "not_enough_thrust"))).forGoggles(tooltip, 1);
                    Lang.builder().add(Component.m_237115_((String)"creatingspace.overlay.flight_recorder.thrust1")).add(Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(this.lastAssemblyData.thrust()), 3))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton"))).forGoggles(tooltip, 2);
                    Lang.builder().add(Component.m_237115_((String)"creatingspace.overlay.flight_recorder.thrust2")).add(Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(this.lastAssemblyData.weight()), 3))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton"))).forGoggles(tooltip, 2);
                }
            } else {
                Lang.builder().add(Component.m_237115_((String)(tradKey + "no_failure"))).forGoggles(tooltip, 1);
            }
        } else {
            Lang.builder().add(Component.m_237115_((String)(tradKey + "no_flight"))).forGoggles(tooltip, 1);
        }
        return true;
    }
}

