/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.rae.creatingspace.server.blocks.FlowGaugeBlock;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.kinetics.gauge.GaugeBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class FlowGaugeBlockEntity
extends GaugeBlockEntity {
    float flow = 0.0f;

    public FlowGaugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new FlowMeterFluidTransportBehaviour((SmartBlockEntity)this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
    }

    public void tick(Level level, BlockPos pos, BlockState state, FlowGaugeBlockEntity flowGaugeBlockEntity) {
        FluidTransportBehaviour behavior = (FluidTransportBehaviour)flowGaugeBlockEntity.getBehaviour(FlowMeterFluidTransportBehaviour.TYPE);
        PipeConnection connection = behavior.getConnection(((Direction)state.m_61143_((Property)FlowGaugeBlock.FACING)).m_122427_());
        PipeConnection reverseConnection = behavior.getConnection(((Direction)state.m_61143_((Property)FlowGaugeBlock.FACING)).m_122428_());
        flowGaugeBlockEntity.flow = FlowGaugeBlockEntity.getCalculatedFlow(connection, reverseConnection);
        flowGaugeBlockEntity.dialTarget = Math.min(flowGaugeBlockEntity.flow / 1000.0f, 1.0f);
        flowGaugeBlockEntity.m_6596_();
        super.tick();
    }

    private static float getCalculatedFlow(PipeConnection connection, PipeConnection reverseConnection) {
        FluidStack pipeFlow;
        Couple pressure;
        float calutatedFlow = 0.0f;
        if (connection != null) {
            pressure = connection.getPressure();
            pipeFlow = connection.provideOutboundFlow();
            calutatedFlow = Math.max(Math.max(((Float)pressure.getFirst()).floatValue(), ((Float)pressure.getSecond()).floatValue()) * (float)pipeFlow.getAmount(), calutatedFlow);
        }
        if (reverseConnection != null) {
            pressure = reverseConnection.getPressure();
            pipeFlow = reverseConnection.provideOutboundFlow();
            calutatedFlow = Math.max(Math.max(((Float)pressure.getFirst()).floatValue(), ((Float)pressure.getSecond()).floatValue()) * (float)pipeFlow.getAmount(), calutatedFlow);
        }
        return calutatedFlow;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect((String)"gui.gauge.info_header", (Object[])new Object[0])));
        tooltip.add((Component)Component.m_237113_((String)String.valueOf(this.flow)).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.flow.millibucket_by_ticks")));
        return true;
    }

    public static class FlowMeterFluidTransportBehaviour
    extends FluidTransportBehaviour {
        public FlowMeterFluidTransportBehaviour(SmartBlockEntity be) {
            super(be);
        }

        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return direction.m_122434_() == ((Direction)state.m_61143_((Property)FlowGaugeBlock.FACING)).m_122427_().m_122434_();
        }
    }
}

