/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.server.blocks.RocketControlsBlock;
import com.rae.creatingspace.server.contraption.RocketContraption;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RocketControlsBlockEntity
extends SmartBlockEntity
implements Nameable,
IDisplayAssemblyExceptions {
    private final Component defaultName;
    private Component customName;
    protected AssemblyException lastException;
    private boolean assembleNextTick = false;
    private ResourceLocation destination;
    public HashMap<String, BlockPos> initialPosMap = new HashMap();

    public RocketControlsBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.defaultName = RocketControlsBlockEntity.getDefaultName();
    }

    public static Component getDefaultName() {
        return ((RocketControlsBlock)((Object)BlockInit.ROCKET_CONTROLS.get())).m_49954_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.defaultName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.notifyUpdate();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.CONTRAPTION_ACTORS});
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public void queueAssembly(ResourceLocation destination) {
        this.assembleNextTick = true;
        this.destination = destination;
    }

    public void queueAssembly() {
        this.assembleNextTick = true;
        this.destination = null;
    }

    private void assemble() {
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof RocketControlsBlock)) {
            return;
        }
        RocketContraption contraption = new RocketContraption();
        try {
            this.lastException = null;
            if (!contraption.assemble(this.f_58857_, this.f_58858_)) {
                return;
            }
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
        contraption.removeBlocksFromWorld(this.f_58857_, BlockPos.f_121853_);
        if (this.destination == null) {
            this.destination = this.f_58857_.m_46472_().m_135782_();
        }
        RocketContraptionEntity rocketContraptionEntity = RocketContraptionEntity.create(this.f_58857_, contraption, this.destination);
        BlockPos anchor = this.f_58858_;
        rocketContraptionEntity.m_6034_(anchor.m_123341_(), anchor.m_123342_(), anchor.m_123343_());
        rocketContraptionEntity.setInitialPosMap(this.initialPosMap);
        rocketContraptionEntity.rocketEntryCoordinate = this.initialPosMap.getOrDefault(this.destination.toString(), this.f_58858_);
        this.f_58857_.m_7967_((Entity)rocketContraptionEntity);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
    }

    public void tick() {
        super.tick();
        assert (this.f_58857_ != null);
        if (!this.initialPosMap.containsKey(this.f_58857_.m_46472_().m_135782_().toString())) {
            this.initialPosMap.put(this.f_58857_.m_46472_().m_135782_().toString(), this.m_58899_());
        }
        if (this.assembleNextTick) {
            this.assemble();
            this.assembleNextTick = false;
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        compound.m_128365_("initialPosMap", (Tag)RocketControlsBlockEntity.putPosMap(this.initialPosMap, new CompoundTag()));
        super.write(compound, clientPacket);
    }

    public static CompoundTag putPosMap(HashMap<String, BlockPos> initialPosMap, CompoundTag compound) {
        if (compound == null) {
            compound = new CompoundTag();
        }
        for (String key : initialPosMap.keySet()) {
            compound.m_128356_("dimensionInitialPosOf:" + key, initialPosMap.get(key).m_121878_());
        }
        return compound;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.lastException = AssemblyException.read((CompoundTag)compound);
        this.initialPosMap = RocketControlsBlockEntity.getPosMap((CompoundTag)compound.m_128423_("initialPosMap"));
        super.read(compound, clientPacket);
    }

    public static HashMap<String, BlockPos> getPosMap(CompoundTag compound) {
        HashMap<String, BlockPos> initialPosMap = new HashMap<String, BlockPos>();
        if (compound != null) {
            for (String key : compound.m_128431_()) {
                if (!key.contains("dimensionInitialPosOf:")) continue;
                initialPosMap.put(key.substring(22), BlockPos.m_122022_((long)compound.m_128454_(key)));
            }
        }
        return initialPosMap;
    }

    public boolean noLocalisation() {
        return this.initialPosMap.isEmpty();
    }

    public HashMap<String, BlockPos> getInitialPosMap() {
        return this.initialPosMap;
    }

    public void setInitialPosMap(HashMap<String, BlockPos> initialPosMap) {
        this.initialPosMap = new HashMap<String, BlockPos>(initialPosMap);
        this.notifyUpdate();
    }
}

