/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.api.IMass;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RocketEngineBlockEntity
extends SmartBlockEntity {
    public int getIsp() {
        return (int)((float)this.getPropellantType().getMaxISP().intValue() * this.getEfficiency());
    }

    public abstract int getThrust();

    public abstract float getEfficiency();

    public abstract PropellantType getPropellantType();

    public RocketEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static class SmallEngine
    extends RocketEngineBlockEntity {
        @Override
        public int getThrust() {
            return (Integer)CSConfigs.SERVER.rocketEngine.smallRocketEngineThrust.get();
        }

        @Override
        public float getEfficiency() {
            return 0.79f;
        }

        @Override
        public PropellantType getPropellantType() {
            return (PropellantType)PropellantTypeInit.METHALOX.get();
        }

        public SmallEngine(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        }
    }

    public static class BigEngine
    extends RocketEngineBlockEntity {
        @Override
        public float getEfficiency() {
            return 0.79f;
        }

        @Override
        public int getThrust() {
            return (Integer)CSConfigs.SERVER.rocketEngine.bigRocketEngineThrust.get();
        }

        @Override
        public PropellantType getPropellantType() {
            return (PropellantType)PropellantTypeInit.METHALOX.get();
        }

        public BigEngine(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        }
    }

    public static class NbtDependent
    extends RocketEngineBlockEntity
    implements IMass {
        int thrust = 1000;
        PropellantType propellantType = (PropellantType)PropellantTypeInit.METHALOX.get();
        Float efficiency = Float.valueOf(1.0f);
        int mass = 0;

        public NbtDependent(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        }

        @Override
        public float getEfficiency() {
            return this.efficiency.floatValue();
        }

        @Override
        public int getThrust() {
            return this.thrust;
        }

        @Override
        public PropellantType getPropellantType() {
            return this.propellantType;
        }

        public void setThrust(int thrust) {
            this.thrust = thrust;
        }

        protected void write(CompoundTag nbt, boolean clientPacket) {
            nbt.m_128405_("thrust", this.thrust);
            nbt.m_128405_("mass", this.mass);
            nbt.m_128350_("efficiency", this.efficiency.floatValue());
            try {
                nbt.m_128365_("propellantType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)PropellantTypeInit.getSyncedPropellantRegistry().m_7981_((Object)this.propellantType)).get().orThrow());
            }
            catch (Exception ignored) {
                nbt.m_128365_("propellantType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)PropellantTypeInit.METHALOX.getId()).get().orThrow());
            }
            super.write(nbt, clientPacket);
        }

        public void read(CompoundTag nbt, boolean clientPacket) {
            super.read(nbt, clientPacket);
            this.setFromNbt(nbt);
        }

        public void setFromNbt(CompoundTag nbt) {
            this.thrust = nbt.m_128451_("thrust");
            this.efficiency = Float.valueOf(nbt.m_128457_("efficiency"));
            this.mass = nbt.m_128451_("mass");
            try {
                this.propellantType = PropellantTypeInit.getSyncedPropellantRegistry().m_6612_((ResourceLocation)ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("propellantType")).get().orThrow()).orElse((PropellantType)PropellantTypeInit.METHALOX.get());
            }
            catch (Exception ignored) {
                this.propellantType = (PropellantType)PropellantTypeInit.METHALOX.get();
            }
        }

        @Override
        public float getMass() {
            return this.mass;
        }

        public void initialize() {
            this.notifyUpdate();
            super.initialize();
        }
    }
}

