/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rae.creatingspace.api.design.ExhaustPackType;
import com.rae.creatingspace.api.design.PowerPackType;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.client.gui.menu.EngineerTableMenu;
import com.rae.creatingspace.init.MiscInit;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class RocketEngineerTableBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public TableInventory inventory;
    public int size = 100;
    public int thrust = 100000;
    public int expansionRatio = 50;
    public ResourceLocation powerPackType;
    public ResourceLocation exhaustPackType;
    public ResourceLocation propellantType;

    public Component m_5446_() {
        return Component.m_237113_((String)"coucou");
    }

    public RocketEngineerTableBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
        this.readScreenData(SyncData.defaultData());
        this.inventory = new TableInventory();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return EngineerTableMenu.create(id, inv, this);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public static CompoundTag fromIngredients(float size, PropellantType type, float totalEfficiency) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("isp", (int)((float)type.getMaxISP().intValue() * totalEfficiency));
        nbt.m_128405_("thrust", (int)size);
        Map<TagKey<Fluid>, Float> map = type.getPropellantRatio();
        nbt.m_128350_("oxFuelRatio", map.values().stream().toList().get(0).floatValue() / map.values().stream().toList().get(1).floatValue());
        nbt.m_128359_("fuelTag", ((TagKey)map.keySet().stream().toList().get(1)).f_203868_().toString());
        nbt.m_128359_("oxidizerTag", ((TagKey)map.keySet().stream().toList().get(0)).f_203868_().toString());
        return nbt;
    }

    public void craftEngine(ItemStack newEngine) {
        System.out.println(newEngine);
        if (this.inventory.isItemValid(0, newEngine)) {
            this.inventory.insertItem(0, newEngine, false);
        }
    }

    public CompoundTag saveScreenData() {
        CompoundTag screenInfo = new CompoundTag();
        screenInfo.m_128405_("thrust", this.thrust);
        screenInfo.m_128405_("size", this.size);
        screenInfo.m_128405_("expansionRatio", this.expansionRatio);
        screenInfo.m_128365_("exhaustPack", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.exhaustPackType).result().orElse(new CompoundTag()));
        screenInfo.m_128365_("powerPack", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.powerPackType).result().orElse(new CompoundTag()));
        screenInfo.m_128365_("propellantType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.propellantType).result().orElse(new CompoundTag()));
        return screenInfo;
    }

    public void readScreenData(CompoundTag screenInfo) {
        this.thrust = screenInfo.m_128451_("thrust");
        this.size = screenInfo.m_128451_("size");
        this.expansionRatio = screenInfo.m_128451_("expansionRatio");
        this.propellantType = ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)screenInfo.m_128423_("propellantType")).result().orElse(null);
        this.exhaustPackType = ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)screenInfo.m_128423_("exhaustPack")).result().orElse(null);
        this.powerPackType = ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)screenInfo.m_128423_("powerPack")).result().orElse(null);
    }

    public void readScreenData(SyncData screenInfo) {
        this.thrust = screenInfo.thrust;
        this.size = screenInfo.size;
        this.expansionRatio = screenInfo.expansionRatio;
        this.exhaustPackType = screenInfo.exhaustPackType;
        this.powerPackType = screenInfo.powerPackType;
        this.propellantType = screenInfo.propellantType;
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("screenInfo", (Tag)this.saveScreenData());
        super.writeSafe(tag);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inventory.deserializeNBT((CompoundTag)tag.m_128423_("inventory"));
        CompoundTag screenInfo = (CompoundTag)tag.m_128423_("screenInfo");
        assert (screenInfo != null);
        this.readScreenData(screenInfo);
        this.notifyUpdate();
    }

    public String toString() {
        return "RocketEngineerTableBlockEntity{size=" + this.size + ", thrust=" + this.thrust + ", expansionRatio=" + this.expansionRatio + ", powerPackType=" + this.powerPackType + ", exhaustPackType=" + this.exhaustPackType + ", propellantType=" + this.propellantType + "}";
    }

    public record SyncData(int thrust, int size, int expansionRatio, ResourceLocation exhaustPackType, ResourceLocation powerPackType, ResourceLocation propellantType) {
        public static SyncData defaultData() {
            return new SyncData(100000, 100, 50, MiscInit.BELL_NOZZLE.getId(), MiscInit.OPEN_CYCLE.getId(), PropellantTypeInit.METHALOX.getId());
        }

        public ExhaustPackType exhaustPackType(boolean client) {
            if (client) {
                return (ExhaustPackType)MiscInit.getSyncedExhaustPackRegistry().m_7745_(this.exhaustPackType);
            }
            return (ExhaustPackType)((Registry)Minecraft.m_91087_().m_91403_().m_105152_().m_6632_(MiscInit.Keys.EXHAUST_PACK_TYPE).orElseThrow()).m_7745_(this.exhaustPackType);
        }

        public PowerPackType powerPackType(boolean client) {
            if (client) {
                return (PowerPackType)MiscInit.getSyncedPowerPackRegistry().m_7745_(this.powerPackType);
            }
            return (PowerPackType)((Registry)Minecraft.m_91087_().m_91403_().m_105152_().m_6632_(MiscInit.Keys.POWER_PACK_TYPE).orElseThrow()).m_7745_(this.powerPackType);
        }

        public static Codec<SyncData> getCoded() {
            return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("thrust").forGetter(i -> i.thrust), (App)Codec.INT.fieldOf("size").forGetter(i -> i.size), (App)Codec.INT.fieldOf("expansionRatio").forGetter(i -> i.expansionRatio), (App)ResourceLocation.f_135803_.fieldOf("exhaustPack").forGetter(i -> i.exhaustPackType), (App)ResourceLocation.f_135803_.fieldOf("powerPack").forGetter(i -> i.powerPackType), (App)ResourceLocation.f_135803_.fieldOf("propellantType").forGetter(i -> i.propellantType)).apply((Applicative)instance, SyncData::new));
        }
    }

    public class TableInventory
    extends ItemStackHandler {
        public TableInventory() {
            super(10);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            RocketEngineerTableBlockEntity.this.m_6596_();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return super.getStackInSlot(slot);
        }
    }
}

