/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blockentities.atmosphere;

import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.init.ingameobject.EntityInit;
import com.rae.creatingspace.server.blocks.atmosphere.RoomPressuriserBlock;
import com.rae.creatingspace.server.blocks.atmosphere.SealerBlock;
import com.rae.creatingspace.server.entities.RoomAtmosphere;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoomPressuriserBlockEntity
extends KineticBlockEntity {
    public FluidTank OXYGEN_TANK = new FluidTank(1000){

        protected void onContentsChanged() {
        }

        public boolean isFluidValid(FluidStack stack) {
            return TagsInit.CustomFluidTags.LIQUID_OXYGEN.matches(stack.getFluid());
        }
    };
    public LazyOptional<IFluidHandler> fluidOptional = LazyOptional.of(() -> this.OXYGEN_TANK);

    public RoomPressuriserBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        Direction localDir;
        if (cap == ForgeCapabilities.FLUID_HANDLER && side == (localDir = (Direction)this.m_58900_().m_61143_((Property)SealerBlock.FACING)).m_122424_()) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tryRoom() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            boolean initialized = false;
            for (RoomAtmosphere room : this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))))) {
                if (room == null) continue;
                initialized = true;
                room.regenerateRoom(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING)));
            }
            if (!initialized) {
                RoomAtmosphere room = new RoomAtmosphere((EntityType)EntityInit.ATMOSPHERE_ENTITY.get(), this.m_58904_());
                room.m_146884_(Vec3.m_82512_((Vec3i)this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))));
                if (this.f_58857_ != null) {
                    this.f_58857_.m_7967_((Entity)room);
                    room.regenerateRoom(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING)));
                }
            }
        }
    }

    public void remove() {
        if (this.f_58857_ != null) {
            for (RoomAtmosphere room : this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))))) {
                if (room == null) continue;
                room.m_6074_();
            }
        }
        super.remove();
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_ && this.getSpeed() != 0.0f && !this.OXYGEN_TANK.isEmpty()) {
            List rooms = this.f_58857_.m_45976_(RoomAtmosphere.class, new AABB(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)RoomPressuriserBlock.FACING))));
            if (rooms.isEmpty()) {
                this.tryRoom();
            }
            for (RoomAtmosphere room : rooms) {
                if (room == null) continue;
                room.addO2(this.OXYGEN_TANK.drain((int)Math.abs(this.getSpeed()), IFluidHandler.FluidAction.EXECUTE).getAmount() * 10);
            }
        }
    }
}

