/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blocks;

import com.rae.creatingspace.client.gui.screen.RocketAssembleScreen;
import com.rae.creatingspace.init.ingameobject.BlockEntityInit;
import com.rae.creatingspace.server.blockentities.RocketControlsBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.TooltipModifier;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

public class RocketControlsBlock
extends Block
implements IBE<RocketControlsBlockEntity>,
TooltipModifier {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ASSEMBLE_NEXT_TICK = BooleanProperty.m_61465_((String)"assemble_next_tick");

    public RocketControlsBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack held = player.m_21205_();
        if (held.m_41619_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.withBlockEntityDo((BlockGetter)level, pos, be -> this.displayScreen((RocketControlsBlockEntity)((Object)((Object)((Object)be))), player)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayScreen(RocketControlsBlockEntity be, Player player) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        ScreenOpener.open((Screen)new RocketAssembleScreen(be));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)0.875, (double)1.0);
            case Direction.SOUTH -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)0.625);
            case Direction.WEST -> Shapes.m_83048_((double)0.375, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0);
            case Direction.EAST -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.625, (double)0.875, (double)1.0);
            default -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)0.875, (double)1.0);
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ASSEMBLE_NEXT_TICK, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{ASSEMBLE_NEXT_TICK});
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, entity, stack);
        if (worldIn.f_46443_) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            be.setInitialPosMap(RocketControlsBlockEntity.getPosMap(stack.m_41784_().m_128469_("initialPosMap")));
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
        });
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos pos, BlockState state) {
        Component customName;
        Item item = this.m_5456_();
        ItemStack stack = new ItemStack((ItemLike)item);
        Optional blockEntityOptional = this.getBlockEntityOptional(blockGetter, pos);
        CompoundTag tag = stack.m_41784_();
        HashMap blockPosHashMap = blockEntityOptional.map(RocketControlsBlockEntity::getInitialPosMap).orElse(null);
        if (blockPosHashMap != null) {
            CompoundTag compoundTag = new CompoundTag();
            tag.m_128365_("initialPosMap", (Tag)RocketControlsBlockEntity.putPosMap(blockPosHashMap, compoundTag));
        }
        if ((customName = (Component)blockEntityOptional.map(RocketControlsBlockEntity::m_7770_).orElse(null)) != null) {
            stack.m_41714_(customName);
        }
        stack.m_41751_(tag);
        return stack;
    }

    public Class<RocketControlsBlockEntity> getBlockEntityClass() {
        return RocketControlsBlockEntity.class;
    }

    public BlockEntityType<? extends RocketControlsBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntityInit.CONTROLS.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : ($0, pos, $1, blockEntity) -> {
            if (blockEntity instanceof RocketControlsBlockEntity) {
                RocketControlsBlockEntity controlsBlock = (RocketControlsBlockEntity)blockEntity;
                controlsBlock.tick();
            }
        };
    }

    public void modify(ItemTooltipEvent context) {
    }
}

