/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blocks.atmosphere;

import com.rae.creatingspace.init.ingameobject.BlockEntityInit;
import com.rae.creatingspace.server.blockentities.atmosphere.OxygenBlockEntity;
import com.rae.creatingspace.server.blockentities.atmosphere.SealerBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class OxygenBlock
extends Block
implements IBE<OxygenBlockEntity> {
    public static final BooleanProperty BREATHABLE = BooleanProperty.m_61465_((String)"breathable");

    public OxygenBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BREATHABLE, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{BREATHABLE}));
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean pIsMoving) {
        BlockState neighborState = level.m_8055_(neighborPos);
        if (((Boolean)state.m_61143_((Property)BREATHABLE)).booleanValue()) {
            this.notifyMaster(level, pos);
        }
    }

    private void notifyMaster(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof OxygenBlockEntity) {
            OxygenBlockEntity oxygenBlockEntity = (OxygenBlockEntity)blockEntity;
            BlockPos masterPos = oxygenBlockEntity.getMasterPos();
            BlockEntity blockEntity2 = level.m_7702_(masterPos);
            if (blockEntity2 instanceof SealerBlockEntity) {
                SealerBlockEntity sealerBlockEntity = (SealerBlockEntity)blockEntity2;
                sealerBlockEntity.oxygenBlockChanged();
            } else {
                level.m_46961_(pos, true);
            }
        }
    }

    public Class<OxygenBlockEntity> getBlockEntityClass() {
        return OxygenBlockEntity.class;
    }

    public BlockEntityType<? extends OxygenBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntityInit.OXYGEN.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new RenderProperties());
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public static class RenderProperties
    implements IClientBlockExtensions {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            return true;
        }
    }
}

