/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.blocks.multiblock;

import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.server.blocks.multiblock.engines.SuperEngineBlock;
import com.simibubi.create.content.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.render.MultiPosDestructionHandler;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;

public class SuperRocketStructuralBlock
extends DirectionalBlock
implements IWrenchable,
IProxyHoveringInformation {
    public SuperRocketStructuralBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_52588_}));
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return BlockInit.SMALL_ROCKET_ENGINE.asStack();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        if (this.stillValid((BlockGetter)level, clickedPos, state)) {
            BlockPos masterPos = SuperRocketStructuralBlock.getMaster((BlockGetter)level, clickedPos, state);
            context = new UseOnContext(level, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), masterPos, context.m_43721_()));
            state = level.m_8055_(masterPos);
        }
        return super.onSneakWrenched(state, context);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState)) {
            BlockPos masterPos = SuperRocketStructuralBlock.getMaster((BlockGetter)pLevel, pPos, pState);
            pLevel.m_6801_(masterPos.hashCode(), masterPos, -1);
            if (!pLevel.m_5776_() && pPlayer.m_7500_()) {
                pLevel.m_46961_(masterPos, false);
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        Level level;
        if (this.stillValid((BlockGetter)pLevel, pCurrentPos, pState)) {
            BlockPos masterPos = SuperRocketStructuralBlock.getMaster((BlockGetter)pLevel, pCurrentPos, pState);
            if (!pLevel.m_183326_().m_183582_(masterPos, (Object)((Block)BlockInit.SMALL_ROCKET_ENGINE.get()))) {
                pLevel.m_186460_(masterPos, (Block)BlockInit.SMALL_ROCKET_ENGINE.get(), 1);
            }
            return pState;
        }
        if (!(pLevel instanceof Level) || (level = (Level)pLevel).m_5776_()) {
            return pState;
        }
        if (!level.m_183326_().m_183582_(pCurrentPos, (Object)this)) {
            level.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public static BlockPos getMaster(BlockGetter level, BlockPos pos, BlockState state) {
        ArrayList<BlockPos> posDiscovered = new ArrayList<BlockPos>();
        BlockPos targetedPos = pos;
        while (!posDiscovered.contains(pos) && posDiscovered.size() < 10) {
            BlockState targetedState = level.m_8055_(targetedPos);
            if (targetedState.m_60713_((Block)BlockInit.SMALL_ENGINE_STRUCTURAL.get())) {
                posDiscovered.add(targetedPos);
            } else if (targetedState.m_60713_((Block)BlockInit.SMALL_ROCKET_ENGINE.get())) {
                return targetedPos;
            }
            if (targetedState.m_61138_((Property)f_52588_)) {
                Direction direction = (Direction)level.m_8055_(targetedPos).m_61143_((Property)f_52588_);
                targetedPos = pos.m_121945_(direction);
                continue;
            }
            return targetedPos;
        }
        return targetedPos;
    }

    public boolean stillValid(BlockGetter level, BlockPos pos, BlockState state) {
        if (!state.m_60713_((Block)this)) {
            return false;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos targetedPos = pos.m_121945_(direction);
        BlockState targetedState = level.m_8055_(targetedPos);
        return targetedState.m_60734_() instanceof SuperRocketStructuralBlock || targetedState.m_60734_() instanceof SuperEngineBlock;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.stillValid((BlockGetter)pLevel, pPos, pState)) {
            pLevel.m_46597_(pPos, Blocks.f_50016_.m_49966_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new RenderProperties());
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public BlockPos getInformationSource(Level level, BlockPos pos, BlockState state) {
        return this.stillValid((BlockGetter)level, pos, state) ? SuperRocketStructuralBlock.getMaster((BlockGetter)level, pos, state) : pos;
    }

    public static class RenderProperties
    implements IClientBlockExtensions,
    MultiPosDestructionHandler {
        public boolean addDestroyEffects(BlockState state, Level Level2, BlockPos pos, ParticleEngine manager) {
            return true;
        }

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            if (target instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)target;
                BlockPos targetPos = bhr.m_82425_();
                @NonnullType SuperRocketStructuralBlock structuralBlock = (SuperRocketStructuralBlock)((Object)BlockInit.ENGINE_STRUCTURAL.get());
                if (structuralBlock.stillValid((BlockGetter)level, targetPos, state)) {
                    manager.m_107367_(SuperRocketStructuralBlock.getMaster((BlockGetter)level, targetPos, state), bhr.m_82434_());
                }
                return true;
            }
            return super.addHitEffects(state, level, target, manager);
        }

        @Nullable
        public Set<BlockPos> getExtraPositions(ClientLevel level, BlockPos pos, BlockState blockState, int progress) {
            @NonnullType SuperRocketStructuralBlock structuralBlock = (SuperRocketStructuralBlock)((Object)BlockInit.ENGINE_STRUCTURAL.get());
            if (!structuralBlock.stillValid((BlockGetter)level, pos, blockState)) {
                return null;
            }
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(SuperRocketStructuralBlock.getMaster((BlockGetter)level, pos, blockState));
            return set;
        }
    }
}

