/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.contraption.behaviour.movement;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.rae.creatingspace.api.rendering.GeometryRendering;
import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.server.entities.RocketContraptionEntity;
import com.rae.creatingspace.utilities.CSDimensionUtil;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.utility.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class EngineMovementBehaviour
implements MovementBehaviour {
    static RandomSource r = RandomSource.m_216327_();
    static float baseRadius = 0.45f;
    static int segments = 4;
    static int N = 50;
    static float maxDistance = 10.0f;
    static float step = 1.0f / (float)N;

    public boolean isActive(MovementContext context) {
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (abstractContraptionEntity instanceof RocketContraptionEntity) {
            RocketContraptionEntity rocketEntity = (RocketContraptionEntity)abstractContraptionEntity;
            boolean flag = rocketEntity.isInPropulsionPhase();
            return super.isActive(context) && flag;
        }
        return false;
    }

    public void tick(MovementContext context) {
        if (context.world == null || !context.world.f_46443_ || context.position == null || context.disabled) {
            return;
        }
        baseRadius = context.state.m_60713_((Block)BlockInit.BIG_ROCKET_ENGINE.get()) ? 0.7f : 0.5f;
    }

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (this.isActive(context)) {
            VertexConsumer vertexBuilder = buffer.m_6299_(RenderTypes.getGlowingTranslucent((ResourceLocation)AllSpecialTextures.BLANK.getLocation()));
            PoseStack matrixStack = matrices.getViewProjection();
            matrixStack.m_85836_();
            Vec3 firstOffset = Vec3.m_82539_((Vec3i)context.localPos.m_7495_());
            matrixStack.m_85837_(firstOffset.f_82479_, firstOffset.f_82480_, firstOffset.f_82481_);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-45.1f));
            int overlay = 0xF000F0;
            float z = 0.0f;
            float w = baseRadius;
            for (float t = 0.0f; t < 1.0f; t += step) {
                float prev_w = w;
                GeometryRendering.renderCylinder(vertexBuilder, matrixStack, new Vec3(0.0, (double)(-(z += EngineMovementBehaviour.d_z(t) * step)), 0.0), EngineMovementBehaviour.getColorBell(t), overlay, w += EngineMovementBehaviour.d_w(t, CSDimensionUtil.hasO2Atmosphere((Holder<Biome>)renderWorld.m_204166_(new BlockPos(new Vec3i((int)context.position.m_7096_(), (int)context.position.m_7098_(), (int)context.position.m_7094_()))))) * step, prev_w, EngineMovementBehaviour.d_z(t) * step, segments, EngineMovementBehaviour.d_z(t) > 0.0f);
                GeometryRendering.renderCylinder(vertexBuilder, matrixStack, new Vec3(0.0, (double)(-z), 0.0), EngineMovementBehaviour.getColorBell(t), overlay, w, prev_w, EngineMovementBehaviour.d_z(t) * step, segments, EngineMovementBehaviour.d_z(t) <= 0.0f);
            }
            matrixStack.m_85849_();
        }
    }

    private static float d_z(float t) {
        return maxDistance;
    }

    private static float d_w(float t, boolean atmospheric) {
        return atmospheric ? -baseRadius : 2.0f * baseRadius;
    }

    private static Color getColorBell(float t) {
        return new Color(2012262415).mixWith(new Color(15505197), Mth.m_14036_((float)(t * 1.5f), (float)0.0f, (float)1.0f));
    }
}

