/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.event;

import com.mojang.brigadier.CommandDispatcher;
import com.rae.creatingspace.init.CSDamageSources;
import com.rae.creatingspace.init.TagsInit;
import com.rae.creatingspace.saved.DesignCommands;
import com.rae.creatingspace.server.armor.OxygenBacktankUtil;
import com.rae.creatingspace.server.blocks.atmosphere.OxygenBlock;
import com.rae.creatingspace.server.entities.RoomAtmosphere;
import com.rae.creatingspace.utilities.CSDimensionUtil;
import com.rae.creatingspace.utilities.CustomTeleporter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="creatingspace")
public class CSEventHandler {
    @SubscribeEvent
    public static void entityLivingEvent(LivingEvent.LivingTickEvent livingTickEvent) {
        ResourceKey<Level> dimensionToTeleport;
        ServerPlayer player;
        LivingEntity entityLiving = livingTickEvent.getEntity();
        Level level = entityLiving.m_9236_();
        ResourceLocation dimension = level.m_46472_().m_135782_();
        if (CSDimensionUtil.isOrbit((ResourceKey<DimensionType>)level.m_220362_()) && !level.f_46443_ && entityLiving instanceof ServerPlayer && (player = (ServerPlayer)entityLiving).m_20186_() < (double)(level.m_6042_().f_156647_() + 10) && (dimensionToTeleport = CSDimensionUtil.planetUnder(dimension)) != null) {
            ServerLevel destServerLevel = Objects.requireNonNull(level.m_7654_()).m_129880_(dimensionToTeleport);
            assert (destServerLevel != null);
            if (player.m_20159_()) {
                Entity vehicle = player.m_20202_();
                assert (vehicle != null);
                vehicle.m_20153_();
                vehicle.changeDimension(destServerLevel, (ITeleporter)new CustomTeleporter(destServerLevel));
                player.changeDimension(destServerLevel, (ITeleporter)new CustomTeleporter(destServerLevel));
                player.m_7998_(vehicle, true);
            } else {
                player.changeDimension(destServerLevel, (ITeleporter)new CustomTeleporter(destServerLevel));
            }
        }
        if (entityLiving.f_19797_ % 20 == 0 && !CSEventHandler.inO2(entityLiving) && entityLiving.m_6097_()) {
            if (entityLiving instanceof ServerPlayer) {
                player = (ServerPlayer)entityLiving;
                if (CSEventHandler.playerNeedEquipment(player)) {
                    if (CSEventHandler.checkPlayerO2Equipment(player)) {
                        ItemStack tank = player.m_6844_(EquipmentSlot.CHEST);
                        OxygenBacktankUtil.consumeOxygen((LivingEntity)player, tank, 1);
                    } else {
                        player.m_6469_(CSDamageSources.no_oxygen(level), 0.5f);
                    }
                }
            } else if (!TagsInit.CustomEntityTag.SPACE_CREATURES.matches((Entity)entityLiving)) {
                entityLiving.m_6469_(CSDamageSources.no_oxygen(level), 0.5f);
            }
        }
        if (entityLiving.f_19797_ % 20 == 0 && !CSEventHandler.inO2(entityLiving) && entityLiving.m_6097_()) {
            if (entityLiving instanceof ServerPlayer) {
                player = (ServerPlayer)entityLiving;
                if (CSEventHandler.playerNeedEquipment(player) && player.m_9236_().m_46472_().m_135782_().toString().equals("creatingspace:venus") && !CSEventHandler.checkPlayerO2Equipment(player)) {
                    player.m_6469_(CSDamageSources.over_heat(level), 0.5f);
                }
            } else if (!TagsInit.CustomEntityTag.SPACE_CREATURES.matches((Entity)entityLiving)) {
                entityLiving.m_6469_(CSDamageSources.over_heat(level), 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void playerSleeping(SleepFinishedTimeEvent sleepFinishedEvent) {
        sleepFinishedEvent.getLevel().m_7654_().m_129880_(Level.f_46428_).m_8615_(sleepFinishedEvent.getNewTime());
    }

    public static boolean checkPlayerO2Equipment(ServerPlayer player) {
        ItemStack chestPlate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        if (TagsInit.CustomItemTags.OXYGEN_SOURCES.matches(chestPlate) && OxygenBacktankUtil.hasOxygenRemaining(chestPlate)) {
            return TagsInit.CustomItemTags.SPACESUIT.matches(chestPlate) && TagsInit.CustomItemTags.SPACESUIT.matches(helmet) && TagsInit.CustomItemTags.SPACESUIT.matches(leggings) && TagsInit.CustomItemTags.SPACESUIT.matches(boots);
        }
        return false;
    }

    public static boolean playerNeedEquipment(ServerPlayer player) {
        return !player.m_7500_();
    }

    public static boolean inO2(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (CSDimensionUtil.hasO2Atmosphere((Holder<Biome>)level.m_204166_(entity.m_20097_()))) {
            return true;
        }
        AABB colBox = entity.m_20191_();
        Stream blockStateStream = level.m_45556_(colBox);
        for (BlockState state : blockStateStream.toList()) {
            if (!CSEventHandler.isStateBreathable(state)) continue;
            return true;
        }
        List entityStream = level.m_45976_(RoomAtmosphere.class, colBox);
        for (RoomAtmosphere atmosphere : entityStream) {
            if (!atmosphere.getShape().inside(colBox) || !atmosphere.breathable()) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        DesignCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static boolean isStateBreathable(BlockState state) {
        return state.m_60734_() instanceof OxygenBlock && (Boolean)state.m_61143_((Property)OxygenBlock.BREATHABLE) != false;
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.NeighborNotifyEvent event) {
        boolean blockPlaced = false;
        boolean blockBreak = false;
        Level level = (Level)event.getLevel();
        AABB colBoxInside = new AABB(event.getPos());
        List entityStream = level.m_45976_(RoomAtmosphere.class, colBoxInside);
        for (RoomAtmosphere atmosphere : entityStream) {
            if (!atmosphere.getShape().inside(colBoxInside)) continue;
            blockPlaced = true;
        }
        if (blockPlaced) {
            for (RoomAtmosphere atmosphere : entityStream) {
                atmosphere.regenerateRoom(atmosphere.m_20097_());
            }
        } else {
            for (Direction direction : event.getNotifiedSides()) {
                AABB colBoxOutside = new AABB(event.getPos().m_121945_(direction));
                entityStream = level.m_45976_(RoomAtmosphere.class, colBoxOutside);
                for (RoomAtmosphere atmosphere : entityStream) {
                    if (!atmosphere.getShape().inside(colBoxOutside)) continue;
                    blockBreak = true;
                }
                if (!blockBreak) continue;
                for (RoomAtmosphere atmosphere : entityStream) {
                    atmosphere.regenerateRoom(atmosphere.m_20097_());
                }
            }
        }
    }
}

