/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.event;

import com.rae.creatingspace.api.planets.RocketAccessibleDimension;
import com.rae.creatingspace.saved.UnlockedDesignManager;
import com.rae.creatingspace.utilities.CSDimensionUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="creatingspace")
public class DataEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static RegistryAccess.Frozen registryAccess = null;

    @SubscribeEvent
    public static void onLoadWorld(LevelEvent.Load event) {
        LevelAccessor world = event.getLevel();
        UnlockedDesignManager.levelLoaded(world);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        UnlockedDesignManager.playerLogin(player);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("getting the server registry access");
        registryAccess = event.getServer().m_206579_();
        LOGGER.info("updating the travel map");
        CSDimensionUtil.updatePlanetsFromRegistry((Registry<RocketAccessibleDimension>)registryAccess.m_175515_(RocketAccessibleDimension.REGISTRY_KEY));
        LOGGER.debug("updating the space travel cost map");
        CSDimensionUtil.updateCostMap();
        CSDimensionUtil.removeUnreachableDimensions();
    }

    public static <T> Registry<T> getSideAwareRegistry(ResourceKey<Registry<T>> registryKey) {
        if (registryAccess != null) {
            return registryAccess.m_175515_(registryKey);
        }
        LOGGER.debug("getting the registry access from the client");
        return (Registry)Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105152_().m_6632_(registryKey).orElseThrow();
    }
}

