/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.items;

import com.google.common.collect.Multimap;
import com.rae.creatingspace.client.gui.menu.UpgradableEquipmentMenu;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradableEquipment
extends BaseArmorItem {
    public UpgradableEquipment(ArmorMaterial armorMaterial, ArmorItem.Type slot, Item.Properties properties, ResourceLocation textureLoc) {
        super(armorMaterial, slot, properties, textureLoc);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new UpgradeInventory(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        if (interactionHand != InteractionHand.OFF_HAND) {
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (offHandStack.m_41720_().canEquip(offHandStack, this.f_265916_.m_266308_(), (Entity)player)) {
                player.m_21008_(InteractionHand.OFF_HAND, UpgradableEquipment.getUpgrade(mainHandStack));
                player.m_21008_(InteractionHand.MAIN_HAND, UpgradableEquipment.setUpgrade(mainHandStack, offHandStack));
            }
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (!world.f_46443_ && player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> UpgradableEquipmentMenu.create(id, inv, context.m_43722_()), (Component)Component.m_237115_((String)"container.my_item_menu")), buf -> buf.m_130055_(context.m_43722_()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public ItemStack m_7968_() {
        return UpgradableEquipment.setUpgrade(super.m_7968_(), ItemStack.f_41583_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ItemStack newStack = UpgradableEquipment.getUpgrade(stack);
        return newStack.m_41619_() ? super.getAttributeModifiers(slot, stack) : newStack.m_41720_().getAttributeModifiers(slot, newStack);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        ItemStack upgrade = UpgradableEquipment.getUpgrade(itemStack);
        if (!upgrade.m_41619_()) {
            components.add((Component)Component.m_237115_((String)"container.upgrade").m_130946_(" : ").m_7220_(upgrade.m_41720_().m_41466_()));
        }
        super.m_7373_(itemStack, level, components, flag);
    }

    @NotNull
    private static ItemStack getUpgrade(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("upgradeElement");
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    private static ItemStack setUpgrade(ItemStack stack, ItemStack upgrade) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_("upgradeElement", (Tag)upgrade.serializeNBT());
        ItemStack newStack = stack.m_41777_();
        newStack.m_41751_(tag);
        return newStack;
    }

    public static class UpgradeInventory
    implements ICapabilityProvider {
        private final ItemStackHandler itemStackHandler = new ItemStackHandler(1);
        private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> this.itemStackHandler);

        public UpgradeInventory(ItemStack stack) {
            CompoundTag nbt = stack.m_41784_();
            this.itemStackHandler.deserializeNBT(nbt.m_128469_("upgradeElement"));
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                return this.handler.cast();
            }
            return LazyOptional.empty();
        }

        public void saveInventory(ItemStack stack) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128365_("upgradeElement", (Tag)this.itemStackHandler.serializeNBT());
            stack.m_41751_(nbt);
        }
    }
}

