/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.items.engine;

import com.mojang.serialization.DynamicOps;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.init.ingameobject.BlockInit;
import com.rae.creatingspace.init.ingameobject.PropellantTypeInit;
import com.rae.creatingspace.server.blocks.multiblock.SmallRocketStructuralBlock;
import com.rae.creatingspace.server.blocks.multiblock.engines.RocketEngineBlock;
import com.rae.creatingspace.server.items.engine.RocketEngineItem;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EngineItem
extends RocketEngineItem {
    public EngineItem(Block p_40565_, Item.Properties p_40566_) {
        super(p_40565_, p_40566_);
    }

    protected boolean m_40610_(BlockPlaceContext pContext, BlockState pState) {
        RocketEngineBlock main = (RocketEngineBlock)this.m_40614_();
        Level lvl = pContext.m_43725_();
        Direction facing = pContext.m_43719_();
        BlockPos mainPos = pContext.m_8083_().m_121955_(main.getOffset(facing));
        return lvl.m_8055_(mainPos).m_60795_() && lvl.m_8055_(mainPos.m_7495_()).m_60795_();
    }

    protected boolean m_7429_(BlockPlaceContext pContext, BlockState pState) {
        RocketEngineBlock main = (RocketEngineBlock)this.m_40614_();
        Level lvl = pContext.m_43725_();
        Direction facing = pContext.m_43719_();
        BlockPos mainPos = pContext.m_8083_().m_121955_(main.getOffset(facing));
        BlockState ghostState = (BlockState)BlockInit.ENGINE_STRUCTURAL.getDefaultState().m_61124_((Property)SmallRocketStructuralBlock.f_52588_, (Comparable)Direction.UP);
        lvl.m_7731_(mainPos, pState, 11);
        lvl.m_7731_(mainPos.m_7495_(), ghostState, 11);
        Player player = pContext.m_43723_();
        ItemStack itemstack = pContext.m_43722_();
        BlockState blockstate1 = lvl.m_8055_(mainPos);
        blockstate1.m_60734_().m_6402_(lvl, mainPos, blockstate1, (LivingEntity)player, itemstack);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, mainPos, itemstack);
        }
        return true;
    }

    public ItemStack m_7968_() {
        int thrust = 1000;
        float efficiency = 1.0f;
        int mass = 3000;
        return this.getItemStackFromInfo(thrust, efficiency, mass, PropellantTypeInit.METHALOX.getId());
    }

    @NotNull
    public ItemStack getItemStackFromInfo(int thrust, float efficiency, int mass, ResourceLocation propellantType) {
        ItemStack defaultInstance = super.m_7968_();
        CompoundTag nbt = defaultInstance.m_41784_();
        CompoundTag beTag = new CompoundTag();
        beTag.m_128405_("thrust", thrust);
        beTag.m_128405_("mass", mass);
        beTag.m_128350_("efficiency", efficiency);
        beTag.m_128365_("propellantType", (Tag)ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)propellantType).get().orThrow());
        nbt.m_128365_("blockEntity", (Tag)beTag);
        defaultInstance.m_41751_(nbt);
        return defaultInstance;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        CompoundTag beTag = itemStack.m_41698_("blockEntity");
        try {
            PropellantType propellantType = (PropellantType)PropellantTypeInit.getSyncedPropellantRegistry().m_6612_(ResourceLocation.f_135803_.parse((DynamicOps)NbtOps.f_128958_, (Object)beTag.m_128423_("propellantType")).resultOrPartial(s -> {}).orElse(PropellantTypeInit.METHALOX.getId())).orElseThrow();
            EngineItem.appendEngineDependentText(components, propellantType, (int)((float)propellantType.getMaxISP().intValue() * beTag.m_128457_("efficiency")), beTag.m_128451_("thrust"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_7373_(itemStack, level, components, flag);
    }
}

