/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.items.engine;

import com.rae.creatingspace.CreatingSpace;
import com.rae.creatingspace.api.design.PropellantType;
import com.rae.creatingspace.configs.CSCfgClient;
import com.rae.creatingspace.configs.CSConfigs;
import com.rae.creatingspace.utilities.CSUtil;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class RocketEngineItem
extends BlockItem {
    public RocketEngineItem(Block p_40565_, Item.Properties p_40566_) {
        super(p_40565_, p_40566_);
    }

    public static void appendEngineDependentText(List<Component> components, int ISP, int thrust) {
        components.add((Component)Component.m_237115_((String)"creatingspace.science.isp").m_7220_((Component)Component.m_237113_((String)(" : " + ISP))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.second")));
        components.add((Component)Component.m_237115_((String)"creatingspace.science.thrust").m_7220_((Component)Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(thrust), 10)))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton")));
    }

    public static void appendEngineDependentText(List<Component> components, int ISP, int mass, int thrust) {
        components.add((Component)Component.m_237115_((String)"creatingspace.science.isp").m_7220_((Component)Component.m_237113_((String)(" : " + ISP))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.second")));
        components.add((Component)Component.m_237115_((String)"creatingspace.science.mass").m_130946_(" : " + mass).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.kilo_gramme")));
        components.add((Component)Component.m_237115_((String)"creatingspace.science.thrust").m_7220_((Component)Component.m_237113_((String)(" : " + CSUtil.scientificNbrFormatting(Float.valueOf(thrust), 10)))).m_7220_((Component)Component.m_237115_((String)"creatingspace.science.unit.newton")));
    }

    public static void appendEngineDependentText(List<Component> components, PropellantType propellantType, int ISP, int thrust) {
        RocketEngineItem.appendEngineDependentText(components, ISP, thrust);
        RocketEngineItem.appendFluidInfo(components, propellantType);
    }

    public static void appendEngineDependentText(List<Component> components, PropellantType propellantType, int ISP, int mass, int thrust) {
        RocketEngineItem.appendEngineDependentText(components, ISP, mass, thrust);
        RocketEngineItem.appendFluidInfo(components, propellantType);
    }

    private static void appendFluidInfo(List<Component> components, PropellantType propellantType) {
        components.add((Component)Component.m_237113_((String)"ratio of fluid consumed :"));
        if (((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.MASS)) {
            for (TagKey<Fluid> fluidTagkey : propellantType.getPropellantRatio().keySet()) {
                components.add((Component)Component.m_237115_((String)("fluid." + fluidTagkey.f_203868_().m_214298_())).m_130940_(ChatFormatting.AQUA).m_130946_(" : ").m_7220_((Component)Component.m_237113_((String)String.valueOf((float)((int)(propellantType.getPropellantRatio().get(fluidTagkey).floatValue() * 1000.0f)) / 10.0f))).m_130946_("%"));
            }
        }
        if (((CSCfgClient.Measurement)((Object)CSConfigs.CLIENT.recorder_measurement.get())).equals((Object)CSCfgClient.Measurement.VOLUMETRIC)) {
            HashMap<Object, Float> collector = new HashMap<Object, Float>();
            float total = 0.0f;
            for (TagKey<Fluid> fluidTagkey : propellantType.getPropellantRatio().keySet()) {
                AtomicReference fluidRef = new AtomicReference();
                ForgeRegistries.FLUIDS.getEntries().forEach(resourceKeyFluidEntry -> {
                    if (((Fluid)resourceKeyFluidEntry.getValue()).m_205067_(fluidTagkey)) {
                        fluidRef.set((Fluid)resourceKeyFluidEntry.getValue());
                    }
                });
                if (fluidRef.get() == null) {
                    CreatingSpace.LOGGER.warn("Warning : failed to find a fluid in game data");
                    continue;
                }
                collector.put(fluidTagkey, Float.valueOf(propellantType.getPropellantRatio().get(fluidTagkey).floatValue() / (float)((Fluid)fluidRef.get()).getFluidType().getDensity()));
                total += propellantType.getPropellantRatio().get(fluidTagkey).floatValue() / (float)((Fluid)fluidRef.get()).getFluidType().getDensity();
            }
            float finalTotal = total;
            collector.forEach((k, v) -> components.add((Component)Component.m_237115_((String)("fluid." + k.f_203868_().m_214298_())).m_130940_(ChatFormatting.AQUA).m_130946_(" : ").m_7220_((Component)Component.m_237113_((String)String.valueOf((float)((int)(((Float)collector.get(k)).floatValue() / finalTotal * 1000.0f)) / 10.0f))).m_130946_("%")));
        }
    }
}

