/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.server.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.rae.creatingspace.init.graphics.ParticleTypeInit;
import com.rae.creatingspace.server.particle.PlumeParticle;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RocketPlumeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<RocketPlumeParticleData> {
    public static final Codec<RocketPlumeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("drag").forGetter(p -> Float.valueOf(p.drag))).apply((Applicative)i, RocketPlumeParticleData::new));
    public static final ParticleOptions.Deserializer<RocketPlumeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<RocketPlumeParticleData>(){

        public RocketPlumeParticleData fromCommand(ParticleType<RocketPlumeParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float drag = reader.readFloat();
            return new RocketPlumeParticleData(drag);
        }

        public RocketPlumeParticleData fromNetwork(ParticleType<RocketPlumeParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new RocketPlumeParticleData(buffer.readFloat());
        }
    };
    public float drag;

    public RocketPlumeParticleData(float drag) {
        this.drag = drag;
    }

    public RocketPlumeParticleData() {
        this(0.0f);
    }

    public ParticleType<?> m_6012_() {
        return ParticleTypeInit.ROCKET_PLUME.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.drag);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %f", ParticleTypeInit.ROCKET_PLUME.parameter(), Float.valueOf(this.drag));
    }

    public ParticleOptions.Deserializer<RocketPlumeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<RocketPlumeParticleData> getCodec(ParticleType<RocketPlumeParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleEngine.SpriteParticleRegistration<RocketPlumeParticleData> getMetaFactory() {
        return PlumeParticle.Factory::new;
    }
}

