/*
 * Decompiled with CFR 0.152.
 */
package com.rae.creatingspace.utilities;

import com.rae.creatingspace.api.planets.RocketAccessibleDimension;
import com.rae.creatingspace.init.TagsInit;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CSDimensionUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<ResourceLocation, RocketAccessibleDimension> travelMap;
    private static List<ResourceLocation> planets;
    private static Map<ResourceLocation, Map<ResourceLocation, Integer>> costAdjacentMap;

    public static Map<ResourceLocation, RocketAccessibleDimension> getTravelMap() {
        if (travelMap == null) {
            LOGGER.info("updating the travel map");
            CSDimensionUtil.updatePlanetsFromRegistry((Registry<RocketAccessibleDimension>)((Registry)Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105152_().m_6632_(RocketAccessibleDimension.REGISTRY_KEY).orElseThrow()));
            LOGGER.info("updating the space travel cost map");
            CSDimensionUtil.updateCostMap();
            CSDimensionUtil.removeUnreachableDimensions();
        }
        return travelMap;
    }

    public static List<ResourceLocation> getPlanets() {
        if (planets == null) {
            LOGGER.info("updating the travel map");
            CSDimensionUtil.updatePlanetsFromRegistry((Registry<RocketAccessibleDimension>)((Registry)Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105152_().m_6632_(RocketAccessibleDimension.REGISTRY_KEY).orElseThrow()));
            LOGGER.info("updating the space travel cost map");
            CSDimensionUtil.updateCostMap();
            CSDimensionUtil.removeUnreachableDimensions();
        }
        return planets;
    }

    public static void removeUnreachableDimensions() {
        planets = planets.stream().filter(l -> {
            Map<ResourceLocation, Integer> cost = costAdjacentMap.get(l);
            for (Map.Entry<ResourceLocation, Integer> entries : cost.entrySet()) {
                if (entries.getValue() <= 0 || entries.getValue() >= Integer.MAX_VALUE) continue;
                return true;
            }
            return false;
        }).toList();
    }

    public static void updatePlanetsFromRegistry(Registry<RocketAccessibleDimension> registry) {
        HashMap collector = new HashMap();
        registry.m_214010_().forEach(resourceKey -> collector.put(resourceKey.m_135782_(), (RocketAccessibleDimension)registry.m_7745_(resourceKey.m_135782_())));
        travelMap = Map.copyOf(collector);
        planets = collector.keySet().stream().toList();
    }

    @Deprecated(forRemoval=true)
    public static float gravity(ResourceKey<DimensionType> dimensionType) {
        return CSDimensionUtil.gravity(dimensionType.m_135782_());
    }

    public static float gravity(ResourceLocation location) {
        RocketAccessibleDimension dimensionParameter;
        if (travelMap != null && (dimensionParameter = travelMap.get(location)) != null) {
            return dimensionParameter.gravity();
        }
        return 9.81f;
    }

    @Deprecated(forRemoval=true)
    public static int arrivalHeight(ResourceKey<DimensionType> dimensionType) {
        return CSDimensionUtil.arrivalHeight(dimensionType.m_135782_());
    }

    public static int arrivalHeight(ResourceLocation location) {
        RocketAccessibleDimension dimensionParameter;
        if (travelMap != null && (dimensionParameter = travelMap.get(location)) != null) {
            return dimensionParameter.arrivalHeight();
        }
        return 64;
    }

    public static Map<ResourceLocation, RocketAccessibleDimension.AccessibilityParameter> accessibleFrom(ResourceLocation currentDimension) {
        if (travelMap != null && travelMap.containsKey(currentDimension)) {
            return travelMap.get(currentDimension).adjacentDimensions();
        }
        return new HashMap<ResourceLocation, RocketAccessibleDimension.AccessibilityParameter>();
    }

    public static boolean hasO2Atmosphere(ResourceLocation biome) {
        return !TagsInit.CustomBiomeTags.NO_OXYGEN.matches(biome);
    }

    public static boolean hasO2Atmosphere(Holder<Biome> biome) {
        return !TagsInit.CustomBiomeTags.NO_OXYGEN.matches(biome);
    }

    public static boolean isOrbit(ResourceKey<DimensionType> dimensionType) {
        return CSDimensionUtil.isOrbit(dimensionType.m_135782_());
    }

    public static boolean isOrbit(ResourceLocation dimension) {
        return CSDimensionUtil.gravity(dimension) == 0.0f;
    }

    @Nullable
    public static ResourceKey<Level> planetUnder(ResourceLocation dimension) {
        if (travelMap != null && travelMap.containsKey(dimension)) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)travelMap.get(dimension).orbitedBody());
        }
        return null;
    }

    private static Map<ResourceLocation, Integer> dijkstra(ResourceLocation start) {
        HashMap<ResourceLocation, Integer> distances = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, Boolean> visited = new HashMap<ResourceLocation, Boolean>();
        for (ResourceLocation location : travelMap.keySet()) {
            distances.put(location, Integer.MAX_VALUE);
            visited.put(location, false);
        }
        distances.put(start, 0);
        PriorityQueue priorityQueue = new PriorityQueue(Map.Entry.comparingByValue());
        priorityQueue.add(new AbstractMap.SimpleEntry<ResourceLocation, Integer>(start, 0));
        while (!priorityQueue.isEmpty()) {
            Map.Entry entry = priorityQueue.poll();
            ResourceLocation current = (ResourceLocation)entry.getKey();
            if (((Boolean)visited.get(current)).booleanValue()) continue;
            visited.put(current, true);
            RocketAccessibleDimension currentDimension = travelMap.get(current);
            if (currentDimension == null) continue;
            for (Map.Entry<ResourceLocation, RocketAccessibleDimension.AccessibilityParameter> adjacent : currentDimension.adjacentDimensions().entrySet()) {
                ResourceLocation target = adjacent.getKey();
                int deltaV = adjacent.getValue().deltaV();
                int newDist = (Integer)distances.get(current) + deltaV;
                if (distances.get(target) != null) {
                    if (newDist >= (Integer)distances.get(target)) continue;
                    distances.put(target, newDist);
                    priorityQueue.add(new AbstractMap.SimpleEntry<ResourceLocation, Integer>(target, newDist));
                    continue;
                }
                LOGGER.warn("unexpected null value loading route from : " + current + " to " + target);
            }
        }
        return distances;
    }

    public static int cost(ResourceLocation from, ResourceLocation to) {
        if (costAdjacentMap == null) {
            CSDimensionUtil.updateCostMap();
            LOGGER.warn("unexpected null value for space travel cost map, reloading");
        }
        return ((Map)costAdjacentMap.getOrDefault(from, new HashMap())).getOrDefault(to, -1);
    }

    public static void updateCostMap() {
        costAdjacentMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
        for (ResourceLocation location : CSDimensionUtil.getTravelMap().keySet()) {
            costAdjacentMap.put(location, CSDimensionUtil.dijkstra(location));
        }
    }
}

